/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.command;

import java.io.IOException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.DefaultChainItemFactory;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.command.ContinuousCommand;
import org.eclipse.scada.da.server.exec.command.ProcessConfiguration;
import org.eclipse.scada.da.server.exec.splitter.SplitResult;
import org.eclipse.scada.da.server.exec.splitter.Splitter;
import org.eclipse.scada.da.server.exec.util.StreamProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContinuousCommand
implements ContinuousCommand,
Runnable {
    private static final int DEFAULT_MAX_INPUT_BUFFER = 4000;
    private static final Logger logger = LoggerFactory.getLogger(AbstractContinuousCommand.class);
    private final ProcessConfiguration processConfiguration;
    private final int restartDelay;
    private final int maxInputBuffer;
    private final String id;
    private Thread thread;
    private boolean running;
    private long lastStartTimestamp = 0L;
    protected FolderItemFactory itemFactory;
    private DataItemInputChained stateItem;
    private State state = State.STOPPED;
    private DataItemInputChained failedItem;
    private final Splitter splitter;
    private Thread readerStdThread;
    private Thread readerErrThread;
    private String inputBuffer;
    private DataItemInputChained pidItem;
    private Process process;
    private DataItemCommand killItem;
    private Thread shutdownHook;

    public AbstractContinuousCommand(String id, ProcessConfiguration processConfiguration, int restartDelay, int maxInputBuffer, Splitter splitter) {
        this.id = id;
        this.processConfiguration = processConfiguration;
        this.restartDelay = restartDelay;
        this.splitter = splitter;
        if (maxInputBuffer > 0) {
            this.maxInputBuffer = maxInputBuffer;
        } else {
            logger.warn(String.format("Using default (%s) max input buffer instead of provided (%s)", 4000, maxInputBuffer));
            this.maxInputBuffer = 4000;
        }
    }

    @Override
    public void start(Hive hive, FolderCommon parentFolder) {
        this.itemFactory = new DefaultChainItemFactory((HiveCommon)hive, parentFolder, this.id, this.id);
        this.stateItem = this.itemFactory.createInput("state", null);
        this.stateItem.updateData(Variant.valueOf((Object)this.state.toString()), null, null);
        this.failedItem = this.itemFactory.createInput("lastFailure", null);
        this.pidItem = this.itemFactory.createInput("pid", null);
        this.killItem = this.itemFactory.createCommand("kill", null);
        this.killItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                AbstractContinuousCommand.this.killProcess();
            }
        });
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractContinuousCommand.this.killProcess();
            }
        }, "ProcessKiller/" + this.id);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.thread = new Thread((Runnable)this, "ProcessRunner/" + this.id);
        this.running = true;
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() {
        this.cancelProcess();
        this.itemFactory.dispose();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.shutdownHook = null;
    }

    private void cancelProcess() {
        this.running = false;
        this.killProcess();
    }

    private void killProcess() {
        Process process = this.process;
        if (process != null) {
            logger.warn("Killing process");
            process.destroy();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean shouldStartProcess() {
        return System.currentTimeMillis() - this.lastStartTimestamp > (long)this.restartDelay;
    }

    protected void processFailed(Throwable e) {
        this.process = null;
        this.setCurrentState(State.DIED);
        if (e != null) {
            this.failedItem.updateData(Variant.valueOf((Object)e.getMessage()), null, null);
        }
        this.pidItem.updateData(Variant.NULL, null, null);
    }

    protected void processStarted(Process process) {
        this.process = process;
    }

    private void startProcess() throws Exception {
        this.lastStartTimestamp = System.currentTimeMillis();
        this.setCurrentState(State.STARTING);
        ProcessBuilder processBuilder = this.processConfiguration.asProcessBuilder();
        this.inputBuffer = "";
        Process process = processBuilder.start();
        try {
            logger.info("Processes started...");
            this.setCurrentState(State.STARTED);
            this.pidItem.updateData(Variant.valueOf((Object)process.toString()), null, null);
            this.processStarted(process);
            StreamProcessor stdProcessor = new StreamProcessor(process.getInputStream(), this.maxInputBuffer){

                @Override
                protected void handleInput(String input) {
                    AbstractContinuousCommand.this.handleStdInput(input);
                }
            };
            this.readerStdThread = new Thread((Runnable)stdProcessor, "StreamStdReader/" + this.id);
            this.readerStdThread.setDaemon(false);
            this.readerStdThread.start();
            StreamProcessor errProcessor = new StreamProcessor(process.getErrorStream(), this.maxInputBuffer){

                @Override
                protected void handleInput(String input) {
                    AbstractContinuousCommand.this.handleErrInput(input);
                }
            };
            this.readerErrThread = new Thread((Runnable)errProcessor, "StreamErrReader/" + this.id);
            this.readerErrThread.setDaemon(false);
            this.readerErrThread.start();
            process.waitFor();
            this.setCurrentState(State.DIED);
        }
        finally {
            this.closeProcess(process);
        }
    }

    private void closeProcess(Process process) {
        try {
            process.getErrorStream().close();
        }
        catch (IOException e) {
            logger.error("Failed to close error stream", (Throwable)e);
            e.printStackTrace();
        }
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            logger.error("Failed to close input stream", (Throwable)e);
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            logger.error("Failed to close output stream", (Throwable)e);
        }
    }

    private void handleErrInput(String buffer) {
        logger.info("Error Input: " + buffer);
    }

    private void handleStdInput(String buffer) {
        this.inputBuffer = this.inputBuffer == null ? buffer : String.valueOf(this.inputBuffer) + buffer;
        SplitResult result = this.splitter.split(this.inputBuffer);
        if (result != null) {
            String[] stringArray = result.getLines();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.handleStdLine(line);
                ++n2;
            }
            this.inputBuffer = result.getRemainingBuffer();
            if (this.inputBuffer == null) {
                this.inputBuffer = "";
            }
        }
        logger.debug("Input buffer size: " + this.inputBuffer.length());
        if (this.inputBuffer.length() > this.maxInputBuffer) {
            logger.warn("Input buffer is too big. Killing process");
            this.killProcess();
        }
    }

    protected abstract void handleStdLine(String var1);

    public void setCurrentState(State state) {
        this.state = state;
        this.stateItem.updateData(Variant.valueOf((Object)state.toString()), null, null);
    }

    public static enum State {
        STOPPED,
        STARTING,
        STARTED,
        DIED;

    }
}

