/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.command;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.command.CommandQueue;
import org.eclipse.scada.da.server.exec.command.SingleCommand;

public class CommandQueueImpl
implements CommandQueue {
    private final String id;
    private final Hive hive;
    private final Collection<Entry> commands = new CopyOnWriteArrayList<Entry>();
    private Timer timer;
    private final int loopDelay;

    public CommandQueueImpl(Hive hive, String id, int loopDelay) {
        this.hive = hive;
        this.id = id;
        this.loopDelay = loopDelay;
    }

    @Override
    public void addCommand(SingleCommand command, int period) {
        this.commands.add(new Entry(command, period));
    }

    @Override
    public void removeCommand(SingleCommand command) {
        Iterator<Entry> i = this.commands.iterator();
        while (i.hasNext()) {
            Entry entry = i.next();
            if (entry.getCommand() != command) continue;
            i.remove();
            return;
        }
    }

    @Override
    public void start(Hive hive, FolderCommon baseFolder) {
        for (Entry entry : this.commands) {
            entry.getCommand().register(hive, baseFolder);
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                CommandQueueImpl.this.runOnce();
            }
        }, new Date(), (long)this.loopDelay);
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (Entry entry : this.commands) {
            entry.getCommand().unregister();
        }
    }

    protected void runOnce() {
        for (Entry entry : this.commands) {
            if (!entry.canExecute()) continue;
            entry.execute();
        }
    }

    private static class Entry {
        private final SingleCommand command;
        private final int period;
        private long lastTimestamp;

        public Entry(SingleCommand command, int period) {
            this.command = command;
            this.period = period;
        }

        public SingleCommand getCommand() {
            return this.command;
        }

        public boolean canExecute() {
            return System.currentTimeMillis() - this.lastTimestamp >= (long)this.period;
        }

        public void execute() {
            this.lastTimestamp = System.currentTimeMillis();
            this.command.execute();
        }
    }
}

