/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.slave.hds;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.hd.server.storage.slave.hds.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWatcher {
    private static final Logger logger = LoggerFactory.getLogger(BaseWatcher.class);
    private final Path base;
    private final WatchService watcher;
    private final WatchKey baseKey;
    private final StorageManager storageManager;
    private final Map<Path, StorageWatcher> watcherMap = new HashMap<Path, StorageWatcher>();
    private final AtomicInteger threadCounter = new AtomicInteger();

    public BaseWatcher(StorageManager storageManager, File base) throws IOException {
        this.storageManager = storageManager;
        this.base = base.toPath();
        this.watcher = FileSystems.getDefault().newWatchService();
        this.baseKey = base.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        logger.debug("Checking for initial storages");
        File[] fileArray = this.base.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            logger.debug("Found initial storage dir - {}", (Object)child);
            this.checkAddStorage(child.toPath());
            ++n2;
        }
        this.startWatcher();
    }

    private void startWatcher() {
        Thread t = new Thread("BaseWatcher/" + this.threadCounter.incrementAndGet()){

            @Override
            public void run() {
                try {
                    BaseWatcher.this.runWatcher();
                }
                catch (ClosedWatchServiceException e) {
                    logger.info("Watcher closed", (Throwable)e);
                }
                catch (Exception e) {
                    logger.warn("Watcher failed", (Throwable)e);
                    BaseWatcher.this.startWatcher();
                }
            }
        };
        t.start();
    }

    protected void runWatcher() throws Exception {
        while (true) {
            WatchKey key = this.watcher.take();
            this.checkKey(key);
        }
    }

    private void checkKey(WatchKey key) throws IOException {
        if (this.baseKey == key) {
            this.checkBaseEvents(key, key.pollEvents());
            if (!this.baseKey.reset()) {
                logger.warn("Base key got invalidated");
                this.watcher.close();
            }
        } else {
            Path base = (Path)key.watchable();
            if (!(key.watchable() instanceof Path)) {
                return;
            }
            StorageWatcher w = this.watcherMap.get(base);
            if (w == null) {
                logger.info("Event for unknown target: {}", (Object)base);
                return;
            }
            try {
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (!(event.context() instanceof Path)) continue;
                    w.handleEvent((Path)key.watchable(), event);
                }
            }
            finally {
                if (!key.reset()) {
                    w.dispose();
                }
            }
        }
    }

    protected void addWatcherMap(Path path, StorageWatcher watcher) {
        this.watcherMap.put(path, watcher);
    }

    protected void removeWatcherMap(Path path) {
        this.watcherMap.remove(path);
    }

    private void checkBaseEvents(WatchKey key, List<WatchEvent<?>> events) {
        for (WatchEvent<?> event : events) {
            if (!(event.context() instanceof Path)) continue;
            Path path = this.base.resolve((Path)event.context());
            logger.debug("Event for {}, {} : {} -> {}", new Object[]{event.context(), key.watchable(), event.kind(), path});
            if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                this.checkDeleteStorage(path);
                continue;
            }
            try {
                this.checkAddStorage(path);
            }
            catch (IOException e) {
                logger.warn("Failed to check for storage", (Throwable)e);
            }
        }
    }

    private void checkDeleteStorage(Path path) {
        StorageWatcher w = this.watcherMap.remove(path);
        if (w != null) {
            logger.debug("Disposing watcher {}", (Object)path);
            w.dispose();
        }
    }

    private void checkAddStorage(Path path) throws IOException {
        if (!this.watcherMap.containsKey(path)) {
            logger.debug("Creating new StorageWatcher for {}", (Object)path);
            new StorageWatcher(this.storageManager, this, path, this.watcher);
        } else {
            logger.debug("Path already known");
        }
    }

    protected void addStorage(String id, File file) throws Exception {
        logger.info("Add storage: {} - {}", (Object)id, (Object)file);
        this.storageManager.addStorage(file);
    }

    public void removeStorage(String id, File file) {
        logger.info("Removing storage: {}", (Object)id);
        this.storageManager.removeStorage(file);
    }

    public void dispose() {
        for (StorageWatcher sw : this.watcherMap.values()) {
            sw.dispose();
        }
        this.watcherMap.clear();
        if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close WatchService", (Throwable)e);
            }
        }
    }

    private static class StorageWatcher {
        private final StorageManager storageManager;
        private final Path path;
        private final BaseWatcher baseWatcher;
        private final WatchKey key;
        private WatchKey nativeKey;
        private String id;
        private final WatchService watcher;

        public StorageWatcher(StorageManager storageManager, BaseWatcher baseWatcher, Path path, WatchService watcher) throws IOException {
            this.storageManager = storageManager;
            this.baseWatcher = baseWatcher;
            this.watcher = watcher;
            this.path = path;
            this.key = path.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            baseWatcher.addWatcherMap(path, this);
            File nativeDir = new File(path.toFile(), "native");
            baseWatcher.addWatcherMap(nativeDir.toPath(), this);
            logger.debug("Checking native dir: {}", (Object)nativeDir);
            if (nativeDir.exists() && nativeDir.isDirectory()) {
                this.nativeKey = nativeDir.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.check();
            }
        }

        public void check() {
            String id = this.storageManager.probe(this.path.toFile());
            logger.debug("Checking - id: {}, file: {}", (Object)id, (Object)this.path);
            if (id == null) {
                logger.info("Path {} is not a valid storage", (Object)this.path);
                this.storageRemoved();
            } else {
                this.storageAdded(id);
            }
        }

        private void storageRemoved() {
            logger.debug("Storage removed");
            if (this.id != null) {
                this.baseWatcher.removeStorage(this.id, this.path.toFile());
                this.id = null;
            }
        }

        private void storageAdded(String id) {
            logger.debug("Storage added: {}", (Object)id);
            try {
                this.id = null;
                this.baseWatcher.addStorage(id, this.path.toFile());
                this.id = id;
            }
            catch (Exception e) {
                logger.warn("Failed to add storage", (Throwable)e);
            }
        }

        public void dispose() {
            logger.debug("Disposing: {}", (Object)this.id);
            this.baseWatcher.removeWatcherMap(this.path);
            this.baseWatcher.removeWatcherMap(new File(this.path.toFile(), "native").toPath());
            this.key.cancel();
            if (this.nativeKey != null) {
                this.nativeKey.cancel();
                this.nativeKey = null;
            }
            if (this.id != null) {
                this.baseWatcher.removeStorage(this.id, this.path.toFile());
            }
        }

        public void handleEvent(Path watchable, WatchEvent<?> event) throws IOException {
            Path path = (Path)event.context();
            logger.debug("Change {} for base: {} on {}", new Object[]{event.kind(), watchable, path});
            if (watchable.endsWith("native") && path.toString().equals("settings.xml")) {
                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) {
                    this.check();
                } else {
                    this.storageRemoved();
                }
            } else if (path.toString().equals("settings.xml")) {
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.nativeKey = new File(watchable.toFile(), "native").toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                }
            } else if (path.toString().endsWith(".hds") && this.id != null) {
                this.storageManager.fileChanged(this.path.toFile(), this.id, path.toFile());
            }
        }
    }
}

