/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.sfp;

import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.NoConnectionException;
import org.eclipse.scada.core.client.common.ClientBaseConnection;
import org.eclipse.scada.core.client.common.IoHandlerFactory;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.BrowseOperationCallback;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.client.Helper;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.client.WriteAttributeOperationCallback;
import org.eclipse.scada.da.client.WriteOperationCallback;
import org.eclipse.scada.da.client.sfp.ConnectionHandler;
import org.eclipse.scada.da.client.sfp.FilterChainBuilder;
import org.eclipse.scada.da.client.sfp.HandlerFactory;
import org.eclipse.scada.da.client.sfp.strategy.ReadAllStrategy;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.protocol.common.IoLoggerFilterChainBuilder;
import org.eclipse.scada.protocol.sfp.Sessions;
import org.eclipse.scada.protocol.sfp.messages.Hello;
import org.eclipse.scada.protocol.sfp.messages.Welcome;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends ClientBaseConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionImpl.class);
    private ReadAllStrategy strategy;
    private long pollTime;
    private final Set<String> subscribedItems = new HashSet<String>();
    private final Map<String, ItemUpdateListener> itemListeners = new HashMap<String, ItemUpdateListener>();
    private final Set<Location> subscribedFolders = new HashSet<Location>();
    private final Map<Location, FolderListener> folderListeners = new HashMap<Location, FolderListener>();

    public ConnectionImpl(ConnectionInformation connectionInformation) throws Exception {
        super((IoHandlerFactory)new HandlerFactory(), (IoLoggerFilterChainBuilder)new FilterChainBuilder(), connectionInformation);
        String pollTime = (String)connectionInformation.getProperties().get("pollTime");
        this.pollTime = pollTime != null ? Long.parseLong(pollTime) : 1000L;
    }

    protected void onConnectionConnected() {
        this.getSession().getConfig().setReaderIdleTime((int)(TimeUnit.MILLISECONDS.toSeconds(this.pollTime) * 3L) + 1);
        this.sendHello();
    }

    private void sendHello() {
        Hello message = new Hello(1, EnumSet.noneOf(Hello.Features.class));
        this.sendMessage(message);
    }

    protected synchronized void handleMessage(Object message) {
        logger.debug("Handle message: {}", message);
        if (message instanceof Welcome) {
            this.processWelcome((Welcome)message);
        } else {
            this.strategy.handleMessage(message);
        }
    }

    private void processWelcome(Welcome message) {
        String charsetName = (String)message.getProperties().get("charset");
        if (charsetName != null) {
            Charset charset = Charset.forName(charsetName);
            Sessions.setCharset((IoSession)this.getSession(), (Charset)charset);
        }
        this.strategy = new ReadAllStrategy(new ConnectionHandler(){

            @Override
            public void sendMessage(Object message) {
                ConnectionImpl.this.sendMessage(message);
            }

            @Override
            public ScheduledExecutorService getExecutor() {
                return ConnectionImpl.this.getExecutor();
            }

            @Override
            public ConnectionState getConnectionState() {
                return ConnectionImpl.this.getState();
            }
        }, this.pollTime);
        this.subscribedItems.clear();
        this.subscribedFolders.clear();
        this.strategy.setAllItemListeners(this.itemListeners);
        this.strategy.setAllFolderListeners(this.folderListeners);
        this.switchState(ConnectionState.BOUND, null);
        logger.debug("Processed welcome");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectionClosed() {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.strategy != null) {
                this.strategy.dispose();
                this.strategy = null;
            }
        }
        super.onConnectionClosed();
    }

    public void browse(Location location, BrowseOperationCallback callback) {
    }

    public void write(String itemId, Variant value, OperationParameters operationParameters, WriteOperationCallback callback) {
        NotifyFuture<WriteResult> future = this.startWrite(itemId, value, operationParameters, null);
        Helper.transformWrite(future, (WriteOperationCallback)callback);
    }

    public void writeAttributes(String itemId, Map<String, Variant> attributes, OperationParameters operationParameters, WriteAttributeOperationCallback callback) {
        NotifyFuture<WriteAttributeResults> future = this.startWriteAttributes(itemId, attributes, operationParameters, null);
        Helper.transformWriteAttributes((WriteAttributeOperationCallback)callback, future);
    }

    public synchronized NotifyFuture<WriteResult> startWrite(String itemId, Variant value, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        if (this.strategy != null) {
            return this.strategy.startWrite(itemId, value);
        }
        return new InstantErrorFuture((Throwable)new IllegalStateException("No connection"));
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(String itemId, Map<String, Variant> attributes, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        return new InstantErrorFuture((Throwable)new RuntimeException("The small footprint protocol does not allow writing attributes"));
    }

    public void subscribeFolder(Location location) throws NoConnectionException, OperationException {
        if (this.subscribedFolders.add(location) && this.strategy != null) {
            this.strategy.subscribeFolder(location);
        }
        this.strategy.subscribeFolder(location);
    }

    public void unsubscribeFolder(Location location) throws NoConnectionException, OperationException {
        this.subscribedFolders.remove(location);
        if (this.subscribedFolders.remove(location) && this.strategy != null) {
            this.strategy.unsubscribeFolder(location);
        }
    }

    public FolderListener setFolderListener(Location location, FolderListener listener) {
        FolderListener old = this.folderListeners.put(location, listener);
        if (this.strategy != null) {
            this.strategy.setFolderListener(location, listener);
        }
        return old;
    }

    public synchronized void subscribeItem(String itemId) throws NoConnectionException, OperationException {
        logger.debug("Subscribe - itemId: {}", (Object)itemId);
        if (this.subscribedItems.add(itemId) && this.strategy != null) {
            this.strategy.subscribeItem(itemId);
        }
    }

    public synchronized void unsubscribeItem(String itemId) throws NoConnectionException, OperationException {
        logger.debug("Unsubscribe - itemId: {}", (Object)itemId);
        if (this.subscribedItems.remove(itemId) && this.strategy != null) {
            this.strategy.unsubscribeItem(itemId);
        }
    }

    public synchronized ItemUpdateListener setItemUpdateListener(String itemId, final ItemUpdateListener listener) {
        logger.debug("Setting item update listener - itemId: {}, listener: {}", (Object)itemId, (Object)listener);
        ItemUpdateListener old = this.itemListeners.put(itemId, listener);
        if (this.strategy != null) {
            this.strategy.setItemUpateListener(itemId, listener);
        } else {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifySubscriptionChange(SubscriptionState.DISCONNECTED, null);
                }
            });
        }
        return old;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }
}

