/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.modbus;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.server.osgi.modbus.ModbusMaster;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;

public class MasterFactory
extends AbstractServiceConfigurationFactory<ModbusMaster> {
    private final Set<Listener> listeners = new HashSet<Listener>();
    private final Map<String, ModbusMaster> masters = new HashMap<String, ModbusMaster>();
    private final ScheduledExecutorService executor;
    private final NioProcessor processor;

    public MasterFactory(BundleContext context, ScheduledExecutorService executor, NioProcessor processor) {
        super(context, true);
        this.executor = executor;
        this.processor = processor;
    }

    protected synchronized AbstractServiceConfigurationFactory.Entry<ModbusMaster> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        ModbusMaster master = ModbusMaster.create(context, this.executor, configurationId, this.processor, parameters);
        this.masters.put(configurationId, master);
        this.fireAdded(configurationId, master);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)master);
    }

    protected synchronized void disposeService(UserInformation userInformation, String configurationId, ModbusMaster service) {
        this.masters.remove(configurationId);
        this.fireRemoved(configurationId, service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<ModbusMaster> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<ModbusMaster> entry, Map<String, String> parameters) throws Exception {
        return null;
    }

    private void fireAdded(String configurationId, ModbusMaster master) {
        for (Listener listener : this.listeners) {
            listener.masterAdded(configurationId, master);
        }
    }

    private void fireRemoved(String configurationId, ModbusMaster master) {
        for (Listener listener : this.listeners) {
            listener.masterRemoved(configurationId, master);
        }
    }

    public synchronized void addMasterListener(Listener listener) {
        if (this.listeners.add(listener)) {
            this.resend(listener);
        }
    }

    public synchronized void removeMasterListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void resend(Listener listener) {
        for (Map.Entry<String, ModbusMaster> entry : this.masters.entrySet()) {
            listener.masterAdded(entry.getKey(), entry.getValue());
        }
    }

    public static interface Listener {
        public void masterAdded(String var1, ModbusMaster var2);

        public void masterRemoved(String var1, ModbusMaster var2);
    }
}

