/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.common;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;

public class StateNotifier {
    private volatile boolean disposed;
    private final ExecutorService executor;
    private final AtomicReference<Set<ConnectionStateListener>> connectionStateListeners = new AtomicReference(Collections.emptySet());
    private final Connection connection;

    public StateNotifier(ExecutorService executor, Connection connection) {
        this.executor = executor;
        this.connection = connection;
    }

    public void fireConnectionStateChange(final ConnectionState connectionState, final Throwable error) {
        if (this.disposed) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StateNotifier.this.doFireConnectionStateChange(connectionState, error);
            }
        });
    }

    protected void doFireConnectionStateChange(ConnectionState connectionState, Throwable error) {
        if (this.disposed) {
            return;
        }
        Set<ConnectionStateListener> listeners = this.connectionStateListeners.get();
        for (ConnectionStateListener listener : listeners) {
            listener.stateChange(this.connection, connectionState, error);
        }
    }

    public void addConnectionStateListener(ConnectionStateListener connectionStateListener) {
        LinkedHashSet<ConnectionStateListener> update;
        Set<ConnectionStateListener> expect;
        do {
            expect = this.connectionStateListeners.get();
            update = new LinkedHashSet<ConnectionStateListener>((Collection)this.connectionStateListeners.get());
            update.add(connectionStateListener);
        } while (!this.connectionStateListeners.compareAndSet(expect, update));
    }

    public void removeConnectionStateListener(ConnectionStateListener connectionStateListener) {
        LinkedHashSet update;
        Set<ConnectionStateListener> expect;
        do {
            expect = this.connectionStateListeners.get();
            update = new LinkedHashSet(this.connectionStateListeners.get());
            update.remove(connectionStateListener);
        } while (!this.connectionStateListeners.compareAndSet(expect, update));
    }

    public void dispose() {
        this.disposed = true;
    }
}

