/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common.query;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.utils.str.StringHelper;

public class SplitNameProvider
implements NameProvider {
    private final Pattern pattern;
    private final NameProvider nameProvider;
    private final int fromStart;
    private final int fromEnd;
    private final String delimiter;

    public SplitNameProvider(NameProvider nameProvider, Pattern pattern, int fromStart, int fromEnd, String delimiter) {
        this.nameProvider = nameProvider;
        this.pattern = pattern;
        this.fromStart = fromStart;
        this.fromEnd = fromEnd;
        this.delimiter = delimiter;
    }

    public SplitNameProvider(NameProvider nameProvider, String pattern, int fromStart, int fromEnd, String delimiter) {
        this(nameProvider, Pattern.compile(pattern), fromStart, fromEnd, delimiter);
    }

    @Override
    public String getName(ItemDescriptor descriptor) {
        String name = this.nameProvider.getName(descriptor);
        LinkedList<String> result = new LinkedList<String>();
        String[] toks = this.pattern.split(name);
        int i = 0;
        while (i < toks.length) {
            if (i < this.fromStart || i >= toks.length - this.fromEnd) {
                result.add(toks[i]);
            }
            ++i;
        }
        return StringHelper.join(result, (String)this.delimiter);
    }
}

