/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.protocol.ngp.codec.impl;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.core.protocol.ngp.codec.Structures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateQueryState
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(UpdateQueryState.class);
    public static final int MESSAGE_CODE = 8708;

    public int getMessageCode() {
        return 8708;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.ae.data.message.UpdateQueryState.class;
    }

    public org.eclipse.scada.ae.data.message.UpdateQueryState decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 8708) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 8708, messageCode));
        }
        int numberOfFields = _data.get();
        long queryId = 0L;
        QueryState state = null;
        ErrorInformation error = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    queryId = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 2: {
                    state = (QueryState)_context.decodeEnum(_data, QueryState.class);
                    break;
                }
                case 3: {
                    error = Structures.decodeErrorInformation((BinaryContext)_context, (IoBuffer)_data, (boolean)false);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.ae.data.message.UpdateQueryState(queryId, state, error);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.ae.data.message.UpdateQueryState value = (org.eclipse.scada.ae.data.message.UpdateQueryState)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(8708);
        data.put((byte)3);
        context.encodePrimitiveLong(data, (byte)1, value.getQueryId());
        context.encodeEnum(data, (byte)2, (Enum)value.getState());
        Structures.encodeErrorInformation((BinaryContext)context, (IoBuffer)data, (byte)3, (ErrorInformation)value.getError());
        data.flip();
        return data;
    }
}

