/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.script;

import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.monitor.script.State;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;

public class ScriptMonitorResult {
    public static final ScriptMonitorResult UNSAFE = new ScriptMonitorResult();
    public static final ScriptMonitorResult INACTIVE;
    State monitorStatus;
    Variant value;
    Long valueTimestamp;
    Severity severity;
    Boolean requireAck;

    static {
        ScriptMonitorResult.UNSAFE.monitorStatus = State.UNSAFE;
        INACTIVE = new ScriptMonitorResult();
        ScriptMonitorResult.INACTIVE.monitorStatus = State.INACTIVE;
    }

    public ScriptMonitorResult() {
    }

    public ScriptMonitorResult(Variant value, Long valueTimestamp) {
        this.monitorStatus = State.OK;
        this.value = value;
        this.valueTimestamp = valueTimestamp;
    }

    public ScriptMonitorResult(Variant value, Long valueTimestamp, Severity severity, boolean requireAck) {
        this.monitorStatus = State.FAILURE;
        this.value = value;
        this.valueTimestamp = valueTimestamp;
        this.severity = severity;
        this.requireAck = requireAck;
    }

    public State getMonitorStatus() {
        return this.monitorStatus;
    }

    public void setMonitorStatus(State monitorStatus) {
        this.monitorStatus = monitorStatus;
    }

    public Variant getValue() {
        return this.value;
    }

    public void setValue(Variant value) {
        this.value = value;
    }

    public Long getValueTimestamp() {
        return this.valueTimestamp;
    }

    public void setValueTimestamp(Long valueTimestamp) {
        this.valueTimestamp = valueTimestamp;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Boolean getRequireAck() {
        return this.requireAck;
    }

    public void setRequireAck(Boolean requireAck) {
        this.requireAck = requireAck;
    }

    public String toString() {
        return String.format("[%s: %s - %s - %s - %s]", new Object[]{this.monitorStatus, this.severity, this.value, this.valueTimestamp, this.requireAck});
    }

    public static class FailureBuilder {
        public static final FailureBuilder INSTANCE = new FailureBuilder();

        public ScriptMonitorResult build(DataItemValue value, Severity severity, boolean requireAck) {
            Variant timestamp = (Variant)value.getAttributes().get("timestamp");
            return new ScriptMonitorResult(value.getValue(), timestamp == null ? null : timestamp.asLong(null), severity, requireAck);
        }

        public ScriptMonitorResult build(Variant value, Long valueTimestamp, Severity severity, boolean requireAck) {
            return new ScriptMonitorResult(value, valueTimestamp, severity, requireAck);
        }
    }

    public static class OkBuilder {
        public static final OkBuilder INSTANCE = new OkBuilder();

        public ScriptMonitorResult build(DataItemValue value) {
            Variant timestamp = (Variant)value.getAttributes().get("timestamp");
            return new ScriptMonitorResult(value.getValue(), timestamp == null ? null : timestamp.asLong(null));
        }

        public ScriptMonitorResult build(Variant value, Long valueTimestamp) {
            return new ScriptMonitorResult(value, valueTimestamp);
        }
    }
}

