/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.client.ngp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.hd.ItemListListener;
import org.eclipse.scada.hd.client.ngp.ConnectionImpl;
import org.eclipse.scada.hd.data.HistoricalItemInformation;

public class ItemManager {
    private final Set<ItemListListener> itemListeners = new LinkedHashSet<ItemListListener>();
    private final Map<String, HistoricalItemInformation> itemCache = new HashMap<String, HistoricalItemInformation>();
    private final Executor executor;
    private final ConnectionImpl connection;
    private boolean disposed;

    public ItemManager(Executor executor, ConnectionImpl connection) {
        this.executor = executor;
        this.connection = connection;
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.onConnectionClosed();
        this.disposed = true;
    }

    public synchronized void addListListener(final ItemListListener listener) {
        if (this.itemListeners.isEmpty()) {
            this.connection.sendBrowseRequestState(true);
        }
        if (this.itemListeners.add(listener)) {
            final HashSet<HistoricalItemInformation> itemCache = new HashSet<HistoricalItemInformation>(this.itemCache.values());
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.listChanged(itemCache, Collections.emptySet(), true);
                }
            });
        }
    }

    private void applyChange(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean full) {
        if (full) {
            this.itemCache.clear();
        }
        if (removed != null) {
            for (String string : removed) {
                this.itemCache.remove(string);
            }
        }
        if (addedOrModified != null) {
            for (HistoricalItemInformation historicalItemInformation : addedOrModified) {
                this.itemCache.put(historicalItemInformation.getItemId(), historicalItemInformation);
            }
        }
    }

    private void fireListChanged(final Set<HistoricalItemInformation> addedOrModified, final Set<String> removed, final boolean fullUpdate) {
        if (this.disposed) {
            return;
        }
        this.applyChange(addedOrModified, removed, fullUpdate);
        final ArrayList<ItemListListener> listeners = new ArrayList<ItemListListener>(this.itemListeners);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (ItemListListener listener : listeners) {
                    listener.listChanged(addedOrModified, removed, fullUpdate);
                }
            }
        });
    }

    public synchronized void removeListListener(ItemListListener listener) {
        this.itemListeners.remove(listener);
        if (this.itemListeners.isEmpty()) {
            this.connection.sendBrowseRequestState(false);
        }
    }

    public synchronized void onConnectionBound() {
        if (!this.itemListeners.isEmpty()) {
            this.connection.sendBrowseRequestState(true);
        }
    }

    public synchronized void onConnectionClosed() {
        this.fireListChanged(null, null, true);
    }

    public synchronized void handleListUpdate(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean fullUpdate) {
        this.fireListChanged(addedOrModified, removed, fullUpdate);
    }
}

