/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common;

import org.eclipse.scada.core.server.common.DefaultAuthentication;
import org.eclipse.scada.sec.AuthenticationException;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.StatusCodes;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.sec.callback.PasswordCallback;
import org.eclipse.scada.sec.utils.password.PasswordType;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.TransformResultFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBasicAuthentication
implements AuthenticationImplementation {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthentication.class);

    public NotifyFuture<UserInformation> authenticate(CallbackHandler callbackHandler) {
        final String plainPassword = this.getPlainPassword();
        if (plainPassword == null || plainPassword.isEmpty()) {
            return new InstantFuture((Object)UserInformation.ANONYMOUS);
        }
        NotifyFuture future = Callbacks.callback((CallbackHandler)callbackHandler, (Callback[])new Callback[]{new PasswordCallback("Password", 200, PasswordType.PLAIN.getSupportedInputEncodings())});
        return new TransformResultFuture<Callback[], UserInformation>(future){

            protected UserInformation transform(Callback[] callbacks) throws Exception {
                return AbstractBasicAuthentication.this.processAuthenticate(callbacks, plainPassword);
            }
        };
    }

    protected abstract String getPlainPassword();

    public UserInformation getUser(String user) {
        return UserInformation.ANONYMOUS;
    }

    protected UserInformation processAuthenticate(Callback[] callbacks, String plainPassword) throws AuthenticationException {
        Callback cb = callbacks[0];
        if (!(cb instanceof PasswordCallback)) {
            logger.debug("Password requested using system properties. But none was provided.");
            throw new AuthenticationException(StatusCodes.INVALID_USER_OR_PASSWORD, "Invalid username or wrong password");
        }
        try {
            if (!PasswordType.PLAIN.createValdiator().validatePassword(((PasswordCallback)cb).getPasswords(), plainPassword)) {
                logger.debug("Password requested using system properties. But none or wrong provided.");
                throw new AuthenticationException(StatusCodes.INVALID_USER_OR_PASSWORD, "Invalid username or wrong password");
            }
        }
        catch (Exception e) {
            logger.warn("Failed to authenticate", (Throwable)e);
            throw new AuthenticationException(StatusCodes.AUTHENTICATION_FAILED, (Throwable)e);
        }
        return UserInformation.ANONYMOUS;
    }
}

