/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.oscar;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.scada.ca.oscar.Messages;

public class OscarLoader {
    private final Map<String, Map<String, Map<String, String>>> data;
    private final Map<String, Set<String>> ignoreFields;
    public static final String OSCAR_SUFFIX = "oscar";
    public static final String OSCAR_DOT_SUFFIX = ".oscar";

    public OscarLoader(InputStream stream) throws Exception {
        ZipEntry entry;
        ZipInputStream zstream = new ZipInputStream(stream);
        Map<String, Map<String, Map<String, String>>> data = null;
        Map<String, Set<String>> ignoreFields = null;
        while ((entry = zstream.getNextEntry()) != null) {
            if ("data.json".equals(entry.getName())) {
                data = OscarLoader.loadJsonData(zstream);
                continue;
            }
            if (!"ignoreFields.json".equals(entry.getName())) continue;
            ignoreFields = OscarLoader.loadIgnoreData(zstream);
        }
        this.data = data;
        this.ignoreFields = ignoreFields;
    }

    public OscarLoader(File file) throws Exception {
        ZipFile zfile = new ZipFile(file);
        try {
            this.data = OscarLoader.loadData(zfile);
            this.ignoreFields = OscarLoader.loadIgnoreData(zfile);
        }
        finally {
            zfile.close();
        }
    }

    private static Map<String, Map<String, Map<String, String>>> loadData(ZipFile zfile) throws IOException, Exception {
        ZipEntry entry = zfile.getEntry("data.json");
        if (entry == null) {
            throw new IllegalArgumentException(Messages.getString("OscarLoader.InvalidFileType"));
        }
        InputStream stream = zfile.getInputStream(entry);
        try {
            Map<String, Map<String, Map<String, String>>> map = OscarLoader.loadJsonData(stream);
            return map;
        }
        finally {
            stream.close();
        }
    }

    private static Map<String, Set<String>> loadIgnoreData(ZipFile zfile) throws IOException, Exception {
        ZipEntry entry = zfile.getEntry("ignoreFields.json");
        if (entry == null) {
            return null;
        }
        InputStream stream = zfile.getInputStream(entry);
        try {
            Map<String, Set<String>> map = OscarLoader.loadIgnoreData(stream);
            return map;
        }
        finally {
            stream.close();
        }
    }

    public Map<String, Map<String, Map<String, String>>> getData() {
        return this.data;
    }

    public Map<String, Set<String>> getIgnoreFields() {
        return this.ignoreFields;
    }

    public static Map<String, Set<String>> loadIgnoreData(InputStream stream) throws Exception {
        Gson g = new GsonBuilder().create();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        return (Map)g.fromJson((Reader)reader, new TypeToken<Map<String, Set<String>>>(){}.getType());
    }

    public static Map<String, Map<String, Map<String, String>>> loadJsonData(InputStream stream) throws Exception {
        Gson g = new GsonBuilder().create();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        return (Map)g.fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Map<String, String>>>>(){}.getType());
    }

    public static boolean isOscar(File file) {
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(OSCAR_DOT_SUFFIX);
    }
}

