/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.dave;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.io.AbstractConnectionDevice;
import org.eclipse.scada.da.server.common.io.PollRequest;
import org.eclipse.scada.da.server.common.memory.AbstractRequestBlock;
import org.eclipse.scada.da.server.dave.DaveBlockConfigurator;
import org.eclipse.scada.da.server.dave.DaveJobManager;
import org.eclipse.scada.da.server.dave.DaveRequestBlock;
import org.eclipse.scada.protocol.dave.DaveConnectionEstablishedMessage;
import org.eclipse.scada.protocol.dave.DaveFilter;
import org.eclipse.scada.protocol.dave.DaveGenericMessage;
import org.eclipse.scada.protocol.dave.DaveMessage;
import org.eclipse.scada.protocol.dave.DaveWriteRequest;
import org.eclipse.scada.protocol.iso8073.COTPFilter;
import org.eclipse.scada.protocols.tkpt.TPKTFilter;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaveDevice
extends AbstractConnectionDevice {
    private static final Logger logger = LoggerFactory.getLogger(DaveDevice.class);
    private Integer rack;
    private Byte slot;
    private final DataItemInputChained configItem;
    private final DaveBlockConfigurator configurator;
    private final DaveJobManager jobManager = new DaveJobManager(this);
    private int readTimeout;

    public DaveDevice(BundleContext context, String id, Map<String, String> properties) throws Exception {
        super(context, id, null, "DaveDevice", "dave");
        HashMap props = new HashMap();
        this.configItem = this.itemFactory.createInput("config", props);
        this.configure(properties);
        this.configurator = new DaveBlockConfigurator(this, this.context);
    }

    public String getItemId(String localId) {
        return super.getItemId(localId);
    }

    protected void performDispose() {
        this.configurator.dispose();
        this.jobManager.dispose();
        super.performDispose();
    }

    protected void configure(Map<String, String> properties) throws Exception {
        logger.info("Applying configuration: {}", properties);
        this.rack = Integer.valueOf(properties.get("rack"));
        this.slot = Byte.valueOf(properties.get("slot"));
        this.readTimeout = DaveDevice.getTimeout(properties, (String)"readTimeout", (int)5000);
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("host", Variant.valueOf((Object)properties.get("host")));
        attributes.put("port", Variant.valueOf((Object)properties.get("port")));
        attributes.put("rack", Variant.valueOf((Object)this.rack));
        attributes.put("slot", Variant.valueOf((Object)this.slot));
        attributes.put("name", Variant.valueOf((Object)properties.get("name")));
        this.configItem.updateData(Variant.TRUE, attributes, AttributeMode.SET);
        super.configure(properties);
    }

    protected void configureConnector(NioSocketConnector connector) {
        connector.getFilterChain().addLast("tpkt", (IoFilter)new TPKTFilter(3));
        connector.getFilterChain().addLast("cotp", (IoFilter)new COTPFilter(this.rack.intValue(), this.slot.byteValue()));
        connector.getFilterChain().addLast("dave", (IoFilter)new DaveFilter());
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public String getId() {
        return this.id;
    }

    public void writeBit(DaveRequestBlock block, int index, int subIndex, boolean value) {
        logger.info("Bit write request - index: {}.{} -> {}", new Object[]{index, subIndex, value});
        DaveWriteRequest request = new DaveWriteRequest();
        request.addRequest((DaveWriteRequest.Request)new DaveWriteRequest.BitRequest(block.getRequest().getArea(), block.getRequest().getBlock(), (short)(index * 8 + subIndex), value));
        this.jobManager.addWriteRequest(request, 0L);
    }

    public void writeData(DaveRequestBlock block, int index, byte[] data) {
        DaveWriteRequest request = new DaveWriteRequest();
        request.addRequest((DaveWriteRequest.Request)new DaveWriteRequest.ByteRequest(block.getRequest().getArea(), block.getRequest().getBlock(), (short)index, data));
        this.jobManager.addWriteRequest(request, 0L);
    }

    public void addBlock(String name, AbstractRequestBlock deviceBlock) {
        this.jobManager.addBlock(name, (PollRequest)deviceBlock);
    }

    public void removeBlock(String block) {
        this.jobManager.removeBlock(block);
    }

    protected synchronized void handleSessionCreated(IoSession session) throws Exception {
        super.handleSessionCreated(session);
        logger.info("Setting reader timeout: {} / {}", (Object)this.readTimeout, (Object)session);
        session.getConfig().setReaderIdleTime(this.readTimeout / 1000);
    }

    protected void handleSessionDisconnected() {
        this.jobManager.setSession(null);
    }

    protected synchronized void handleMessageReceived(IoSession session, Object message) throws Exception {
        super.handleMessageReceived(session, message);
        if (message instanceof DaveConnectionEstablishedMessage) {
            logger.info("DAVE Connection established");
            this.jobManager.setSession(session);
        } else if (message instanceof DaveMessage) {
            this.jobManager.messageReceived(message);
        } else if (message instanceof DaveGenericMessage) {
            logger.info("Message received: {}", message);
        }
    }
}

