/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.rest;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.scada.base.json.VariantJsonDeserializer;
import org.eclipse.scada.base.json.VariantJsonSerializer;
import org.eclipse.scada.core.VariantEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json", "text/plain"})
@Consumes(value={"application/json", "text/plain"})
public class VariantProvider
implements MessageBodyWriter<org.eclipse.scada.core.Variant>,
MessageBodyReader<org.eclipse.scada.core.Variant> {
    private static final Logger logger = LoggerFactory.getLogger(VariantProvider.class);
    private static final MediaType[] SUPPORTED_TYPES_ARRAY = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE};
    private final Gson gson;

    public VariantProvider() {
        logger.debug("Created instance");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(org.eclipse.scada.core.Variant.class, (Object)new VariantJsonSerializer());
        builder.registerTypeAdapter(org.eclipse.scada.core.Variant.class, (Object)new VariantJsonDeserializer());
        this.gson = builder.create();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        logger.trace("isWritable");
        return org.eclipse.scada.core.Variant.class.isAssignableFrom(type);
    }

    public long getSize(org.eclipse.scada.core.Variant t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(org.eclipse.scada.core.Variant t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        logger.trace("writeTo");
        if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
            PrintWriter writer = new PrintWriter(entityStream);
            writer.print(this.gson.toJson((Object)t));
            writer.flush();
        } else if (MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType)) {
            PrintWriter writer = new PrintWriter(entityStream);
            writer.print(t.toString());
            writer.flush();
        } else {
            throw new WebApplicationException(Response.notAcceptable((List)Variant.mediaTypes((MediaType[])SUPPORTED_TYPES_ARRAY).build()).build());
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        logger.trace("isReadable - mediaType: {}", (Object)mediaType);
        MediaType[] mediaTypeArray = SUPPORTED_TYPES_ARRAY;
        int n = SUPPORTED_TYPES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType mt = mediaTypeArray[n2];
            if (mt.isCompatible(mediaType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public org.eclipse.scada.core.Variant readFrom(Class<org.eclipse.scada.core.Variant> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        logger.trace("readFrom");
        if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
            return this.variantFromJson(entityStream, (String)mediaType.getParameters().get("charset"));
        }
        if (MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType)) {
            return this.variantFromString(entityStream, (String)mediaType.getParameters().get("charset"));
        }
        throw new WebApplicationException(Response.notAcceptable((List)Variant.mediaTypes((MediaType[])SUPPORTED_TYPES_ARRAY).build()).build());
    }

    private org.eclipse.scada.core.Variant variantFromString(InputStream entityStream, String charsetName) throws IOException {
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        InputStreamReader reader = new InputStreamReader(entityStream, Charset.forName(charsetName));
        String data = CharStreams.toString((Readable)reader);
        VariantEditor ve = new VariantEditor();
        ve.setAsText(data);
        return (org.eclipse.scada.core.Variant)ve.getValue();
    }

    private org.eclipse.scada.core.Variant variantFromJson(InputStream entityStream, String charsetName) throws IOException {
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        InputStreamReader reader = new InputStreamReader(entityStream, Charset.forName(charsetName));
        return (org.eclipse.scada.core.Variant)this.gson.fromJson((Reader)reader, org.eclipse.scada.core.Variant.class);
    }
}

