/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.rest.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.server.exporter.rest.ItemResource;
import org.eclipse.scada.da.server.exporter.rest.WriteResult;
import org.eclipse.scada.da.server.exporter.rest.internal.DataContext;
import org.eclipse.scada.da.server.exporter.rest.internal.DataContextProvider;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemResourceImpl
implements ItemResource {
    private static final Logger logger = LoggerFactory.getLogger(ItemResourceImpl.class);
    private DataContextProvider provider;

    public void setProvider(DataContextProvider provider) {
        this.provider = provider;
    }

    @Override
    public DataItemValue read(String contextId, String itemId) {
        logger.trace("Reading - contextId: {}, itemId: {}", (Object)contextId, (Object)itemId);
        DataContext context = this.provider.getContext(contextId);
        if (context == null) {
            logger.trace("Context not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        DataItemValue value = context.getValue(itemId);
        if (value == null) {
            logger.trace("Item not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        logger.trace("Result: {}", (Object)value);
        return value;
    }

    @Override
    public WriteResult write(String contextId, String itemId, Variant value) {
        logger.trace("Writing value - contextId: {}, itemId: {}, value: {}", new Object[]{contextId, itemId, value});
        DataContext context = this.provider.getContext(contextId);
        if (context == null) {
            logger.trace("Context not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        NotifyFuture<org.eclipse.scada.da.core.WriteResult> future = context.writeValue(itemId, value);
        try {
            org.eclipse.scada.da.core.WriteResult result = (org.eclipse.scada.da.core.WriteResult)future.get();
            return new WriteResult(result.getError());
        }
        catch (ExecutionException e) {
            Throwable cause = ExceptionHelper.getRootCause((Throwable)e);
            if (cause instanceof InvalidOperationException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            }
            throw new WebApplicationException(e.getCause());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @Override
    public Map<String, WriteResult> writeAttribute(String contextId, String itemId, Map<String, Variant> attributes) {
        logger.trace("Writing attributes - contextId: {}, itemId: {}, attributes: {}", new Object[]{contextId, itemId, attributes});
        DataContext context = this.provider.getContext(contextId);
        if (context == null) {
            logger.trace("Context not found");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        NotifyFuture<WriteAttributeResults> future = context.writeAttributes(itemId, attributes);
        try {
            WriteAttributeResults result = (WriteAttributeResults)future.get();
            HashMap<String, WriteResult> r = new HashMap<String, WriteResult>();
            for (Map.Entry entry : result.entrySet()) {
                r.put((String)entry.getKey(), new WriteResult(((WriteAttributeResult)entry.getValue()).getError()));
            }
            return r;
        }
        catch (ExecutionException e) {
            throw new WebApplicationException(e.getCause());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

