/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.connection;

import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.factory.DataItemFactory;
import org.eclipse.scada.da.server.proxy.Hive;
import org.eclipse.scada.da.server.proxy.connection.ProxyConnection;
import org.eclipse.scada.da.server.proxy.item.ProxyDataItem;
import org.eclipse.scada.da.server.proxy.utils.ProxyPrefixName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDataItemFactory
implements DataItemFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProxyDataItemFactory.class);
    private final String separator;
    private final ProxyPrefixName prefix;
    private final ProxyConnection connection;
    private final Hive hive;

    public ProxyDataItemFactory(ProxyPrefixName prefix, ProxyConnection connection, Hive hive, String separator) {
        this.separator = separator;
        this.prefix = prefix;
        this.connection = connection;
        this.hive = hive;
    }

    public boolean canCreate(String requestItemId) {
        logger.info("Checking request: {} for {}", (Object)requestItemId, (Object)this.prefix);
        return requestItemId.startsWith(String.valueOf(this.prefix.getName()) + this.separator);
    }

    public void create(String requestItemId) {
        if (!this.canCreate(requestItemId)) {
            return;
        }
        ProxyDataItem item = this.connection.realizeItem(requestItemId);
        this.hive.registerItem((DataItem)item);
    }
}

