/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.item;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.NoConnectionException;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.DataItemInputOutputChained;
import org.eclipse.scada.da.server.proxy.item.ProxyValueHolder;
import org.eclipse.scada.da.server.proxy.item.ProxyWriteHandler;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class ProxyDataItem
extends DataItemInputOutputChained {
    private final ProxyValueHolder proxyValueHolder;
    private final ProxyWriteHandler writeHandler;

    public ProxyDataItem(String id, ProxyValueHolder proxyValueHolder, ProxyWriteHandler writeHandler, Executor executor) {
        super((DataItemInformation)new DataItemInformationBase(id, EnumSet.allOf(IODirection.class)), executor);
        this.proxyValueHolder = proxyValueHolder;
        this.proxyValueHolder.setListener(new ItemUpdateListener(){

            public void notifyDataChange(Variant value, Map<String, Variant> attributes, boolean cache) {
                ProxyDataItem.this.updateData(value, attributes, cache ? AttributeMode.SET : AttributeMode.UPDATE);
            }

            public void notifySubscriptionChange(SubscriptionState subscriptionState, Throwable subscriptionError) {
            }
        });
        this.writeHandler = writeHandler;
    }

    public ProxyValueHolder getProxyValueHolder() {
        return this.proxyValueHolder;
    }

    public NotifyFuture<WriteAttributeResults> startSetAttributes(final Map<String, Variant> attributes, final OperationParameters operationParameters) {
        FutureTask task = new FutureTask((Callable)new Callable<WriteAttributeResults>(){

            @Override
            public WriteAttributeResults call() throws Exception {
                return ProxyDataItem.this.processSetAttributes(attributes, operationParameters);
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    protected WriteAttributeResults processSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        WriteAttributeResults writeAttributeResults = super.processSetAttributes(attributes, operationParameters);
        for (Map.Entry entry : writeAttributeResults.entrySet()) {
            if (!((WriteAttributeResult)entry.getValue()).isSuccess()) continue;
            attributes.remove(entry.getKey());
        }
        this.writeHandler.writeAttributes(this.getInformation().getName(), attributes, writeAttributeResults, operationParameters);
        return writeAttributeResults;
    }

    public void setTemplateAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        super.processSetAttributes(attributes, operationParameters);
    }

    protected NotifyFuture<WriteResult> startWriteCalculatedValue(final Variant value, final OperationParameters operationParameters) {
        FutureTask task = new FutureTask((Callable)new Callable<WriteResult>(){

            @Override
            public WriteResult call() throws Exception {
                ProxyDataItem.this.processWriteCalculatedValue(value, operationParameters);
                return new WriteResult();
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    protected void processWriteCalculatedValue(Variant value, OperationParameters operationParameters) throws NotConvertableException, InvalidOperationException {
        try {
            this.writeHandler.write(this.getInformation().getName(), value, operationParameters);
        }
        catch (NoConnectionException noConnectionException) {
            throw new InvalidOperationException();
        }
        catch (OperationException operationException) {
            throw new InvalidOperationException();
        }
    }
}

