/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ae.client.Connection;
import org.eclipse.scada.ae.client.MonitorListener;
import org.eclipse.scada.ae.client.internal.MonitorSyncController;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;

public class MonitorManager
implements ConnectionStateListener {
    private final Connection connection;
    private boolean connected;
    private final Map<String, MonitorSyncController> monitorListeners = new HashMap<String, MonitorSyncController>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorManager(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        this.connection = connection;
        MonitorManager monitorManager = this;
        synchronized (monitorManager) {
            this.connection.addConnectionStateListener(this);
            this.connected = this.connection.getState() == ConnectionState.BOUND;
        }
    }

    public void stateChange(org.eclipse.scada.core.client.Connection connection, ConnectionState state, Throwable error) {
        switch (state) {
            case BOUND: {
                if (this.connected) break;
                this.connected = true;
                break;
            }
            case CLOSED: {
                for (MonitorSyncController controller : this.monitorListeners.values()) {
                    controller.dispose();
                }
                this.monitorListeners.clear();
            }
            default: {
                if (!this.connected) break;
                this.connected = false;
            }
        }
    }

    public synchronized void addMonitorListener(String id, MonitorListener listener) {
        MonitorSyncController monitorSyncController = this.monitorListeners.get(id);
        if (monitorSyncController == null) {
            monitorSyncController = new MonitorSyncController(this.connection, id);
            this.monitorListeners.put(id, monitorSyncController);
        }
        monitorSyncController.addListener(listener);
    }

    public synchronized void removeMonitorListener(String id, MonitorListener listener) {
        MonitorSyncController monitorSyncController = this.monitorListeners.get(id);
        if (monitorSyncController == null) {
            return;
        }
        monitorSyncController.removeListener(listener);
    }

    public boolean isConnected() {
        return this.connected;
    }
}

