/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.totalizer;

import java.io.Serializable;
import java.util.Date;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.buffer.BufferedDataSource;
import org.eclipse.scada.da.buffer.BufferedDataSourceListener;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.base.AbstractInputDataSource;
import org.eclipse.scada.da.datasource.data.DataItemValueLight;
import org.eclipse.scada.da.datasource.data.DataItemValueRange;
import org.eclipse.scada.da.datasource.totalizer.TotalizerState;
import org.eclipse.scada.ds.DataListener;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.DataNodeTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.osgi.pool.SingleObjectPoolServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalizerDataSource
extends AbstractInputDataSource
implements BufferedDataSourceListener,
SingleObjectPoolServiceTracker.ServiceListener<BufferedDataSource>,
DataListener {
    private static final Logger logger = LoggerFactory.getLogger(TotalizerDataSource.class);
    private final ScheduledExecutorService scheduler;
    private final ObjectPoolTracker<BufferedDataSource> poolTracker;
    private String bufferedDataSourceId;
    private SingleObjectPoolServiceTracker<BufferedDataSource> objectPoolTracker;
    private final DataNodeTracker dataNodeTracker;
    private BufferedDataSource bufferedDataSource;
    private Double total = 0.0;
    private long lastTimestamp = System.currentTimeMillis();
    private ScheduledFuture<?> scheduledFuture;
    private TimeUnit unit;
    private String nodeId;

    public TotalizerDataSource(ScheduledExecutorService scheduler, ObjectPoolTracker<BufferedDataSource> poolTracker, DataNodeTracker dataNodeTracker) {
        this.scheduler = scheduler;
        this.poolTracker = poolTracker;
        this.dataNodeTracker = dataNodeTracker;
    }

    protected Executor getExecutor() {
        return this.scheduler;
    }

    public void update(Map<String, String> parameters) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.bufferedDataSourceId = cfg.getStringChecked("buffered.datasource.id", String.format("'%s' must be set", "buffered.datasource.id"));
        TimeUnit reset = (TimeUnit)cfg.getEnumChecked("reset", TimeUnit.class, "'reset' must be set");
        this.unit = (TimeUnit)cfg.getEnumChecked("unit", TimeUnit.class, "'unit' must be set");
        EnumSet<TimeUnit> allowed = EnumSet.of(TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS);
        if (!allowed.contains((Object)reset) || !allowed.contains((Object)this.unit)) {
            throw new IllegalArgumentException("only " + allowed + " TimeUnits are allowed");
        }
        this.nodeId = cfg.getString("node.id", "org.eclipse.scada.da.datasource.totalizer/" + this.bufferedDataSourceId);
        this.objectPoolTracker = new SingleObjectPoolServiceTracker(this.poolTracker, this.bufferedDataSourceId, (SingleObjectPoolServiceTracker.ServiceListener)this);
        this.objectPoolTracker.open();
        this.dataNodeTracker.addListener(this.nodeId, (DataListener)this);
        this.scheduledFuture = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TotalizerDataSource.this.reset();
            }
        }, this.toNearestInstant(System.currentTimeMillis(), reset), reset.toMillis(1L), TimeUnit.MILLISECONDS);
    }

    private void reset() {
        logger.debug("reset totalizer for {}", (Object)this.bufferedDataSourceId);
        this.total = 0.0;
        this.lastTimestamp = System.currentTimeMillis();
    }

    private void updateTotal(DataItemValueRange.DataItemValueRangeState dataItemValueRangeState) {
        logger.trace("updateTotal");
        DataItemValueLight diLast = dataItemValueRangeState.getFirstValue();
        long now = System.currentTimeMillis();
        logger.trace("{}", (Object)dataItemValueRangeState);
        for (DataItemValueLight di : dataItemValueRangeState.getValues()) {
            if (di.getTimestamp() > this.lastTimestamp) {
                Long delta = di.getTimestamp() - this.lastTimestamp;
                Long baseUnit = TimeUnit.MILLISECONDS.convert(1L, this.unit);
                double factor = delta.doubleValue() / baseUnit.doubleValue();
                double v = di.getValue().asDouble(Double.valueOf(0.0)) * factor;
                logger.trace("range: update total, delta t = {}, baseUnit = {}, factor = {}, v = {}", new Object[]{delta, baseUnit, factor, v});
                this.total = this.total + v;
                this.lastTimestamp = di.getTimestamp();
            }
            diLast = di;
        }
        if (now > diLast.getTimestamp()) {
            Long delta = now - this.lastTimestamp;
            Long baseUnit = TimeUnit.MILLISECONDS.convert(1L, this.unit);
            double factor = delta.doubleValue() / baseUnit.doubleValue();
            double v = diLast.getValue().asDouble(Double.valueOf(0.0)) * factor;
            logger.trace("last: update total, delta t = {}, baseUnit = {}, factor = {}, v = {}", new Object[]{delta, baseUnit, factor, v});
            this.total = this.total + v;
            this.lastTimestamp = now;
        }
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("timestamp", Variant.valueOf((long)this.lastTimestamp));
        this.dataNodeTracker.write(new DataNode(this.nodeId, (Serializable)new TotalizerState(this.lastTimestamp, this.total)));
        this.updateData(new DataItemValue(Variant.valueOf((Object)this.total), attributes, SubscriptionState.CONNECTED));
    }

    public void stateChanged(DataItemValueRange dataItemValueRange) {
        this.updateTotal(dataItemValueRange.getState());
    }

    public void dispose() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        if (this.objectPoolTracker != null) {
            this.objectPoolTracker.close();
            this.objectPoolTracker = null;
        }
        this.setBufferedDataSource(null);
    }

    public void serviceChange(BufferedDataSource service, Dictionary<?, ?> properties) {
        this.setBufferedDataSource(service);
    }

    public void nodeChanged(DataNode node) {
        if (node != null) {
            TotalizerState state = (TotalizerState)node.getDataAsObject(((Object)((Object)this)).getClass().getClassLoader(), (Object)new TotalizerState(new Date().getTime(), 0.0));
            this.total = state.getTotal();
            this.lastTimestamp = state.getTimestamp();
        }
    }

    private synchronized void setBufferedDataSource(BufferedDataSource service) {
        if (service == null && this.bufferedDataSource != null) {
            this.bufferedDataSource.removeListener((BufferedDataSourceListener)this);
        } else {
            this.bufferedDataSource = service;
            this.bufferedDataSource.addListener((BufferedDataSourceListener)this);
        }
    }

    private long toNearestInstant(long timestamp, TimeUnit reset) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(timestamp);
        switch (reset) {
            case DAYS: {
                cal.add(6, 1);
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case HOURS: {
                cal.add(10, 1);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case MINUTES: {
                cal.add(12, 1);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case SECONDS: {
                cal.add(13, 1);
                cal.set(14, 0);
                break;
            }
        }
        return cal.getTimeInMillis() - timestamp;
    }
}

