/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.negate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.common.AbstractCommonHandlerImpl;
import org.eclipse.scada.da.master.common.internal.Activator;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.util.tracker.ServiceTracker;

public class NegateHandlerImpl
extends AbstractCommonHandlerImpl {
    private boolean active;
    private final String attrValueOriginal;
    private final String attrActive = this.getPrefixed("active", Activator.getStringInterner());

    public NegateHandlerImpl(String configurationId, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker) {
        super(configurationId, poolTracker, priority, caTracker, "org.eclipse.scada.da.negate.input", "org.eclipse.scada.da.negate.input");
        this.attrValueOriginal = this.getPrefixed("value.original", Activator.getStringInterner());
    }

    @Override
    protected void processDataUpdate(Map<String, Object> context, DataItemValue.Builder builder) throws Exception {
        Variant val;
        this.injectAttributes(builder);
        if (this.active) {
            builder.setAttribute(this.attrValueOriginal, builder.getValue());
        }
        if ((val = builder.getValue()) == null || val.isNull()) {
            return;
        }
        builder.setValue(this.handleDataUpdate(builder.getValue()));
    }

    private Variant handleDataUpdate(Variant value) {
        if (!this.active) {
            return value;
        }
        return Variant.valueOf((!value.asBoolean() ? 1 : 0) != 0);
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        super.update(userInformation, parameters);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.active = cfg.getBoolean("active", false);
        this.reprocess();
    }

    protected void injectAttributes(DataItemValue.Builder builder) {
        builder.setAttribute(this.attrActive, this.active ? Variant.TRUE : Variant.FALSE);
    }

    protected WriteAttributeResults handleUpdate(Map<String, Variant> attributes, OperationParameters operationParameters) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        Variant active = attributes.get("active");
        if (active != null && !active.isNull()) {
            data.put("active", active.asString());
        }
        return this.updateConfiguration(data, attributes, false, operationParameters);
    }
}

