/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.MasterItemHandler;
import org.eclipse.scada.da.master.WriteRequest;
import org.eclipse.scada.da.master.WriteRequestResult;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMasterHandlerImpl
implements MasterItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMasterHandlerImpl.class);
    private final Set<MasterItem> items = new CopyOnWriteArraySet<MasterItem>();
    private final int defaultPriority;
    private final ObjectPoolTracker<MasterItem> poolTracker;
    private volatile int priority;
    private final Map<String, ObjectPoolServiceTracker<MasterItem>> trackers = new HashMap<String, ObjectPoolServiceTracker<MasterItem>>();
    protected Map<String, Variant> eventAttributes;

    public AbstractMasterHandlerImpl(ObjectPoolTracker<MasterItem> poolTracker) {
        this(poolTracker, Integer.MAX_VALUE);
    }

    public AbstractMasterHandlerImpl(ObjectPoolTracker<MasterItem> poolTracker, int defaultPriority) {
        this.poolTracker = poolTracker;
        this.defaultPriority = defaultPriority;
        this.priority = defaultPriority;
        this.eventAttributes = Collections.emptyMap();
    }

    public synchronized void dispose() {
        this.closeTrackers();
    }

    private void closeTrackers() {
        for (ObjectPoolServiceTracker<MasterItem> tracker : this.trackers.values()) {
            tracker.close();
        }
        this.trackers.clear();
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        String masterId = cfg.getStringChecked("master.id", String.format("'%s' must be set", "master.id"));
        String splitPattern = cfg.getString("splitPattern", ", ?");
        String[] newIds = masterId.split(splitPattern);
        boolean trackerUpdate = !this.trackers.keySet().equals(new HashSet<String>(Arrays.asList(newIds)));
        logger.debug("Need tracker update: {}", (Object)trackerUpdate);
        if (trackerUpdate) {
            this.closeTrackers();
        }
        this.priority = cfg.getInteger("handlerPriority", this.defaultPriority);
        this.eventAttributes = this.convert(cfg.getPrefixed("info."));
        if (trackerUpdate) {
            this.createTrackers(newIds);
            for (ObjectPoolServiceTracker<MasterItem> tracker : this.trackers.values()) {
                tracker.open();
            }
        }
    }

    private Map<String, Variant> convert(Map<String, String> attributes) {
        HashMap<String, Variant> result = new HashMap<String, Variant>(attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            result.put(entry.getKey(), Variant.valueOf((Object)entry.getValue()));
        }
        return result;
    }

    protected void createTrackers(String[] masterIds) {
        String[] stringArray = masterIds;
        int n = masterIds.length;
        int n2 = 0;
        while (n2 < n) {
            String masterId = stringArray[n2];
            this.trackers.put(masterId, (ObjectPoolServiceTracker<MasterItem>)new ObjectPoolServiceTracker(this.poolTracker, masterId, (ObjectPoolListener)new ObjectPoolListener<MasterItem>(){

                public void serviceAdded(MasterItem service, Dictionary<?, ?> properties) {
                    AbstractMasterHandlerImpl.this.addItem(service);
                }

                public void serviceModified(MasterItem service, Dictionary<?, ?> properties) {
                }

                public void serviceRemoved(MasterItem service, Dictionary<?, ?> properties) {
                    AbstractMasterHandlerImpl.this.removeItem(service);
                }
            }));
            ++n2;
        }
    }

    protected boolean removeItem(MasterItem item) {
        logger.debug("Removing master: {}", (Object)item);
        if (this.items.remove(item)) {
            logger.debug("Removed master: {}", (Object)item);
            item.removeHandler(this);
            return true;
        }
        return false;
    }

    protected void addItem(MasterItem item) {
        logger.debug("Adding master: {}", (Object)item);
        if (this.items.add(item)) {
            logger.debug("Added master: {} / {}", new Object[]{item, this.priority});
            item.addHandler(this, this.priority);
        }
    }

    protected Collection<MasterItem> getMasterItems() {
        return Collections.unmodifiableCollection(this.items);
    }

    protected void reprocess() {
        for (MasterItem item : this.items) {
            item.reprocess();
        }
    }

    @Override
    public abstract void dataUpdate(Map<String, Object> var1, DataItemValue.Builder var2);

    @Override
    public WriteRequestResult processWrite(WriteRequest request) {
        return null;
    }
}

