/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl.stats;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.impl.stats.CounterOutput;
import org.eclipse.scada.da.server.common.impl.stats.DataItemCounterOutput;
import org.eclipse.scada.da.server.common.impl.stats.HiveStatisticsGenerator;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;

public class HiveCommonStatisticsGenerator
extends HiveStatisticsGenerator {
    private HiveCommon hive;
    private final String itemPrefix;
    private FolderCommon folder;
    private DataItemCounterOutput attributeWritesOutput;
    private DataItemCounterOutput valuesWritesOutput;
    private DataItemCounterOutput itemsOutput;
    private DataItemCounterOutput sessionsOutput;
    private ScheduledExecutorService timer;
    private DataItemCounterOutput attributeEventsOutput;
    private DataItemCounterOutput valueEventsOutput;

    public HiveCommonStatisticsGenerator(String itemPrefix) {
        this.itemPrefix = itemPrefix;
        this.attributeWritesOutput = new DataItemCounterOutput(this.getId("attributeWrites"));
        this.attributeWritesCounter.setOutput(this.attributeWritesOutput);
        this.valuesWritesOutput = new DataItemCounterOutput(this.getId("valueWrites"));
        this.valueWritesCounter.setOutput(this.valuesWritesOutput);
        this.itemsOutput = new DataItemCounterOutput(this.getId("items"));
        this.itemsValue.setOutput(this.itemsOutput);
        this.sessionsOutput = new DataItemCounterOutput(this.getId("sessions"));
        this.sessionsValue.setOutput(this.sessionsOutput);
        this.attributeEventsOutput = new DataItemCounterOutput(this.getId("attributeEvents"));
        this.attributeEventsCounter.setOutput(this.attributeEventsOutput);
        this.valueEventsOutput = new DataItemCounterOutput(this.getId("valueEvents"));
        this.valueEventsCounter.setOutput(this.valueEventsOutput);
    }

    public void register(HiveCommon hive, FolderCommon folder) {
        this.unregister();
        this.hive = hive;
        this.folder = folder;
        this.registerOutput("sessions", this.sessionsOutput, "Number of connected sessions");
        this.registerOutput("items", this.itemsOutput, "Number of registered items");
        this.registerOutput("attributeWrites", this.attributeWritesOutput, "Number of attribute write operations");
        this.registerOutput("valueWrites", this.valuesWritesOutput, "Number of value write operations");
        this.registerOutput("valueEvents", this.valueEventsOutput, "Number of value events");
        this.registerOutput("attributeEvents", this.attributeEventsOutput, "Number of attribute events");
        this.timer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HiveStatsTimer"));
        this.timer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                HiveCommonStatisticsGenerator.this.tick();
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected void registerOutput(String name, CounterOutput output, String description) {
        output.register(this.hive, this.folder, description);
    }

    protected void unregisterOutput(String name, CounterOutput output) {
        output.unregister(this.hive, this.folder);
    }

    public void unregister() {
        if (this.hive != null) {
            this.unregisterOutput("sessions", this.sessionsOutput);
            this.unregisterOutput("items", this.itemsOutput);
            this.unregisterOutput("futureWrappers", this.itemsOutput);
            this.unregisterOutput("attributeWrites", this.attributeWritesOutput);
            this.unregisterOutput("valueWrites", this.valuesWritesOutput);
            this.unregisterOutput("attributeEvents", this.attributeEventsOutput);
            this.unregisterOutput("valueEvents", this.valueEventsOutput);
            this.hive = null;
        }
        if (this.folder != null) {
            this.folder = null;
        }
        if (this.timer != null) {
            this.timer.shutdown();
            this.timer = null;
        }
    }

    protected String getId(String itemId) {
        return String.valueOf(this.itemPrefix) + "." + itemId;
    }
}

