/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component;

import java.util.Stack;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.FolderListener;
import org.eclipse.scada.da.server.component.ActivationHandle;
import org.eclipse.scada.da.server.component.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentFolder
implements Folder {
    private static final Logger logger = LoggerFactory.getLogger(ComponentFolder.class);
    private final FolderCommon folderImpl = new FolderCommon();
    private boolean state;
    private Component component;
    private ActivationHandle handle;
    private boolean active;

    public synchronized void setComponent(Component component) {
        if (this.component != null) {
            this.deactivate();
        }
        this.component = component;
        if (this.component != null && this.active) {
            this.activate();
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public Entry[] list(Stack<String> path) throws NoSuchFolderException {
        return this.folderImpl.list(path);
    }

    public void subscribe(Stack<String> path, FolderListener listener, Object tag) throws NoSuchFolderException {
        this.folderImpl.subscribe(path, listener, tag);
        this.check();
    }

    public void unsubscribe(Stack<String> path, Object tag) throws NoSuchFolderException {
        this.folderImpl.unsubscribe(path, tag);
        this.check();
    }

    private synchronized void check() {
        if (this.folderImpl.hasSubscribers() != this.state) {
            this.state = this.folderImpl.hasSubscribers();
            if (this.state) {
                this.activate();
            } else {
                this.deactivate();
            }
        }
    }

    private void deactivate() {
        logger.info("Deactivate");
        if (this.handle != null) {
            this.handle.dispose();
            this.handle = null;
        }
        this.active = false;
    }

    private void activate() {
        logger.info("Activate");
        this.active = true;
        if (this.handle == null) {
            this.handle = this.component.activate();
        }
    }

    public void added() {
        this.folderImpl.added();
    }

    public void removed() {
        this.folderImpl.removed();
    }

    public FolderCommon getFolderImpl() {
        return this.folderImpl;
    }
}

