/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.jdbc;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.DefaultChainItemFactory;
import org.eclipse.scada.da.server.jdbc.AbstractQuery;
import org.eclipse.scada.da.server.jdbc.ConnectionFactory;
import org.eclipse.scada.da.server.jdbc.Hive;
import org.eclipse.scada.da.server.jdbc.Update;

public class Connection {
    private final Collection<AbstractQuery> queries = new LinkedList<AbstractQuery>();
    private final Collection<Update> updates = new LinkedList<Update>();
    private final String uri;
    private final String id;
    private DefaultChainItemFactory itemFactory;
    private final Integer timeout;
    private final ConnectionFactory connectionFactory;
    private final String connectionClass;
    private final Properties properties;

    public Connection(ConnectionFactory connectionFactory, String id, Integer timeout, String connectionClass, String uri, Properties properties) {
        this.connectionFactory = connectionFactory;
        this.uri = uri;
        this.properties = properties;
        this.id = id;
        this.timeout = timeout;
        this.connectionClass = connectionClass;
    }

    public void add(AbstractQuery query) {
        this.queries.add(query);
    }

    public void register(Hive hive, FolderCommon rootFolder, ScheduledExecutorService timer) {
        this.itemFactory = new DefaultChainItemFactory((HiveCommon)hive, rootFolder, this.id, this.id);
        for (AbstractQuery query : this.queries) {
            query.register(timer, this.itemFactory);
        }
        for (Update update : this.updates) {
            update.register(this.itemFactory);
        }
    }

    public void unregister(Hive hive) {
        for (AbstractQuery query : this.queries) {
            query.unregister();
        }
        for (Update update : this.updates) {
            update.unregister();
        }
        if (this.itemFactory != null) {
            this.itemFactory.dispose();
            this.itemFactory = null;
        }
    }

    protected java.sql.Connection createConnection() throws Exception {
        return this.connectionFactory.createConnection(this.connectionClass, this.uri, this.properties, this.timeout);
    }

    public java.sql.Connection getConnection() throws Exception {
        return this.createConnection();
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void add(Update update) {
        this.updates.add(update);
    }
}

