/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.connection.service;

import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.DriverFactory;
import org.eclipse.scada.core.connection.provider.AbstractConnectionService;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionManager<ConnectionServiceType extends ConnectionService>
implements SingleServiceListener<DriverFactory> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionManager.class);
    private final ConnectionInformation connectionInformation;
    private final BundleContext context;
    private final String connectionId;
    private SingleServiceTracker<DriverFactory> tracker;
    private ServiceRegistration<?> serviceReg;
    private DriverFactory factory;
    private AbstractConnectionService connection;
    private final Class<ConnectionServiceType> clazz;

    public AbstractConnectionManager(Class<ConnectionServiceType> clazz, BundleContext context, String connectionId, ConnectionInformation connectionInformation) {
        Filter filter;
        this.clazz = clazz;
        this.context = context;
        this.connectionId = connectionId;
        this.connectionInformation = connectionInformation;
        String interfaceName = connectionInformation.getInterface();
        String driverName = connectionInformation.getDriver();
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("interface", interfaceName);
            parameters.put("driver", driverName);
            filter = FilterUtil.createAndFilter((String)DriverFactory.class.getName(), parameters);
        }
        catch (InvalidSyntaxException e) {
            filter = null;
            logger.warn("Failed to create filter", (Throwable)e);
        }
        if (filter != null) {
            this.tracker = new SingleServiceTracker(this.context, filter, (SingleServiceListener)this);
            this.tracker.open();
        } else {
            this.tracker = null;
        }
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        this.disposeConnection();
    }

    public void serviceChange(ServiceReference<DriverFactory> reference, DriverFactory factory) {
        logger.info("Service changed: {}/{}", reference, (Object)factory);
        this.disposeConnection();
        this.factory = factory;
        if (factory != null) {
            this.createConnection();
        }
    }

    protected void createConnection() {
        this.connection = this.createConnectionService(this.factory, this.connectionInformation);
        if (this.connection != null) {
            this.connection.connect();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("service.pid", this.connectionId);
            properties.put("interface", this.connectionInformation.getInterface());
            properties.put("driver", this.connectionInformation.getDriver());
            logger.info("Registered new connection service: {}", properties);
            this.serviceReg = this.context.registerService(new String[]{this.clazz.getName(), ConnectionService.class.getName()}, (Object)this.connection, properties);
        }
    }

    protected abstract AbstractConnectionService createConnectionService(DriverFactory var1, ConnectionInformation var2);

    protected void disposeConnection() {
        if (this.serviceReg != null) {
            AbstractConnectionService connection = this.connection;
            connection.disconnect();
            this.connection = null;
            this.serviceReg.unregister();
            this.serviceReg = null;
            connection.dispose();
        }
    }
}

