/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.sfp.strategy;

import org.eclipse.scada.protocol.sfp.messages.WriteResult;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteHandler
extends AbstractFuture<org.eclipse.scada.da.core.WriteResult> {
    private static final Logger logger = LoggerFactory.getLogger(WriteHandler.class);

    public void complete(WriteResult writeResult) {
        logger.debug("Completing write operation - errorCode: {}, errorMessage: {}", (Object)writeResult.getErrorCode(), (Object)writeResult.getErrorMessage());
        if (writeResult.getErrorCode() == 0) {
            this.setResult(org.eclipse.scada.da.core.WriteResult.OK);
        } else {
            this.setError(new RuntimeException(WriteHandler.makeErrorString(writeResult)));
        }
    }

    public static String makeErrorString(WriteResult writeResult) {
        if (writeResult.getErrorMessage() == null) {
            return String.format("%04x", writeResult.getErrorCode());
        }
        return String.format("%04x: %s", writeResult.getErrorCode(), writeResult.getErrorMessage());
    }
}

