/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.eclipse.scada.core.subscription.SubscriptionManagerListener;
import org.eclipse.scada.da.server.component.ActivationHandle;
import org.eclipse.scada.da.server.component.ComponentHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Component {
    private static final Logger logger = LoggerFactory.getLogger(Component.class);
    private final Executor executor;
    private final SubscriptionManagerListener<String> subscriptionListener;
    private final ComponentHost componentHost;
    private final Set<ActivationHandle> handles = new HashSet<ActivationHandle>();

    public Component(Executor executor, ComponentHost componentHost, String activationPrefix) {
        this.executor = executor;
        this.componentHost = componentHost;
        this.subscriptionListener = new PatternActivationListener(Pattern.compile("^" + Pattern.quote(activationPrefix)));
        componentHost.addItemSubscriptionListener(this.subscriptionListener);
    }

    public void dispose() {
        this.componentHost.removeItemSubscriptionListener(this.subscriptionListener);
        this.stop();
    }

    public ActivationHandle activate() {
        return this.register(new ActivationHandle(){

            @Override
            public void dispose() {
                Component.this.unregister(this);
            }
        });
    }

    private synchronized ActivationHandle register(ActivationHandle activationHandle) {
        boolean wasEmpty = this.handles.isEmpty();
        this.handles.add(activationHandle);
        if (wasEmpty && !this.handles.isEmpty()) {
            this.start();
        }
        return activationHandle;
    }

    private synchronized void unregister(ActivationHandle activationHandle) {
        boolean wasEmpty = this.handles.isEmpty();
        this.handles.remove(activationHandle);
        if (!wasEmpty && this.handles.isEmpty()) {
            this.stop();
        }
    }

    public synchronized void start() {
        logger.debug("Start");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                logger.debug("Perform start");
                Component.this.performStart();
            }
        });
    }

    public synchronized void stop() {
        logger.debug("Stop");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                logger.debug("Perform stop");
                Component.this.performStop();
            }
        });
    }

    protected abstract void performStart();

    protected abstract void performStop();

    private class PatternActivationListener
    implements SubscriptionManagerListener<String> {
        private final Pattern pattern;
        private int count;
        private ActivationHandle handle;

        public PatternActivationListener(Pattern pattern) {
            this.pattern = pattern;
        }

        public synchronized void subscriptionsAdded(Set<String> additions) {
            for (String itemId : additions) {
                logger.trace("Checking item: {}", (Object)itemId);
                if (!this.pattern.matcher(itemId).find()) continue;
                logger.trace("Increment: {} (before)", (Object)this.count);
                ++this.count;
            }
            if (this.count == 1) {
                logger.debug("Activate");
                this.handle = Component.this.activate();
            }
        }

        public synchronized void subscriptionsRemoved(Set<String> removals) {
            for (String itemId : removals) {
                logger.trace("Checking item: {}", (Object)itemId);
                if (!this.pattern.matcher(itemId).find()) continue;
                logger.trace("Decrement: {} (before)", (Object)this.count);
                --this.count;
            }
            if (this.count == 0) {
                logger.debug("Deactivate");
                if (this.handle != null) {
                    this.handle.dispose();
                    this.handle = null;
                }
            }
        }
    }
}

