/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.component.Component;
import org.eclipse.scada.da.server.component.ComponentFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentNode {
    private static final Logger logger = LoggerFactory.getLogger(ComponentNode.class);
    private final Map<String, ComponentNode> nodes = new HashMap<String, ComponentNode>();
    private final Map<String, Component> components = new HashMap<String, Component>();
    private final FolderCommon folder;
    private final ComponentNode parentNode;

    public ComponentNode(ComponentNode parentNode, FolderCommon folder) {
        this.parentNode = parentNode;
        this.folder = folder;
    }

    public void registerComponent(LinkedList<String> prefix, ComponentFolder componentFolder, Component component) {
        String next = prefix.pop();
        if (prefix.isEmpty()) {
            this.add(next, componentFolder, component);
        } else {
            ComponentNode node = this.nodes.get(next);
            if (node == null) {
                if (this.components.containsKey(next)) {
                    this.checkRemove();
                    throw new IllegalStateException("Namespace blocked by other component");
                }
                FolderCommon folder = new FolderCommon();
                this.folder.add(next, (Folder)folder, null);
                node = new ComponentNode(this, folder);
                this.nodes.put(next, node);
            }
            node.registerComponent(prefix, componentFolder, component);
        }
    }

    public void unregisterComponent(LinkedList<String> prefix, Component component) {
        String next = prefix.pop();
        if (prefix.isEmpty()) {
            this.remove(next, component);
        } else {
            ComponentNode node = this.nodes.get(next);
            if (node == null) {
                return;
            }
            node.unregisterComponent(prefix, component);
        }
    }

    private void add(String name, ComponentFolder componentFolder, Component component) {
        if (this.components.containsKey(name)) {
            throw new IllegalStateException("There is already a component registered with this name");
        }
        if (!this.folder.add(name, (Folder)componentFolder, null)) {
            throw new IllegalStateException("Namespace is blocked by other component");
        }
        this.components.put(name, component);
    }

    private void remove(String name, Component component) {
        logger.debug("Removing - name: {}, component: {}", (Object)name, (Object)component);
        Component c = this.components.get(name);
        if (c == component) {
            this.components.remove(name);
            this.folder.remove(name);
            this.checkRemove();
        }
    }

    private void checkRemove() {
        if (this.parentNode != null && this.folder.size() == 0) {
            this.parentNode.remove(this);
        }
    }

    private void remove(ComponentNode componentNode) {
        Iterator<Map.Entry<String, ComponentNode>> i = this.nodes.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue() != componentNode) continue;
            i.remove();
        }
        this.checkRemove();
    }
}

