/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common.osgi;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.osgi.AuthorizationTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPrivilegeTracker {
    private static final Logger logger = LoggerFactory.getLogger(SessionPrivilegeTracker.class);
    private final Set<AuthorizationTracker.Monitor> monitors = new LinkedHashSet<AuthorizationTracker.Monitor>();
    private final Set<String> granted = new HashSet<String>();
    private final Executor executor;
    private volatile PrivilegeListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionPrivilegeTracker(Executor executor, PrivilegeListener listener, AuthorizationTracker tracker, Set<String> privileges, UserInformation userInformation) {
        this.executor = executor;
        this.listener = listener;
        logger.debug("Start tracking privileges for user: {}", (Object)userInformation);
        SessionPrivilegeTracker sessionPrivilegeTracker = this;
        synchronized (sessionPrivilegeTracker) {
            for (String privilege : privileges) {
                logger.debug("Start tracking: {}", (Object)privilege);
                AuthorizationTracker.Monitor monitor = tracker.createMonitor((AuthorizationTracker.Listener)new ListenerImpl(privilege), new AuthorizationRequest("SESSION", privilege, "PRIV", userInformation, null));
                this.monitors.add(monitor);
            }
        }
    }

    public synchronized void privilegeChange(String privilege, AuthorizationReply result) {
        logger.debug("Privilege change - privilege: {}, result: {}", (Object)privilege, (Object)result);
        if (result.isGranted()) {
            this.granted.add(privilege);
        } else {
            this.granted.remove(privilege);
        }
        this.fireChange(Collections.unmodifiableSet(this.granted));
    }

    private void fireChange(final Set<String> granted) {
        if (this.listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                PrivilegeListener listener = SessionPrivilegeTracker.this.listener;
                if (listener != null) {
                    listener.privilegesChanged(granted);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SessionPrivilegeTracker sessionPrivilegeTracker = this;
        synchronized (sessionPrivilegeTracker) {
            this.listener = null;
        }
        for (AuthorizationTracker.Monitor monitor : this.monitors) {
            monitor.dispose();
        }
        this.monitors.clear();
    }

    private class ListenerImpl
    implements AuthorizationTracker.Listener {
        private final String privilege;

        public ListenerImpl(String privilege) {
            this.privilege = privilege;
        }

        public void resultChanged(AuthorizationReply result) {
            SessionPrivilegeTracker.this.privilegeChange(this.privilege, result);
        }
    }

    public static interface PrivilegeListener {
        public void privilegesChanged(Set<String> var1);
    }
}

