/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.ByteOrder;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.ScalarVariable;
import org.eclipse.scada.da.server.common.memory.accessor.Int16Accessor;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;

public class WordVariable
extends ScalarVariable {
    private final ByteOrder order;

    public WordVariable(String name, int index, ByteOrder order, Executor executor, ManageableObjectPool<DataItem> itemPool, Attribute ... attributes) {
        super(name, index, executor, itemPool, attributes);
        this.order = order;
    }

    @Override
    protected NotifyFuture<WriteResult> handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            return new InstantErrorFuture((Throwable)new IllegalStateException("Device is not connected"));
        }
        Integer i = value.asInteger(null);
        if (i != null) {
            IoBuffer data = IoBuffer.allocate((int)2);
            this.order.put(data, Int16Accessor.INSTANCE, i.shortValue());
            block.writeData(this.toAddress(this.index), data.array());
            return new InstantFuture((Object)new WriteResult());
        }
        return new InstantErrorFuture((Throwable)new IllegalArgumentException(String.format("Can only write doubles: %s is not a double", value)));
    }

    @Override
    protected Variant extractValue(IoBuffer data, Map<String, Variant> attributes) {
        short s = this.order.get(data, this.toAddress(this.index), Int16Accessor.INSTANCE);
        return Variant.valueOf((int)s);
    }
}

