/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component.parser.factory.configuration.impl;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.scada.da.server.component.parser.factory.configuration.AttributeValue;
import org.eclipse.scada.da.server.component.parser.factory.configuration.Component;
import org.eclipse.scada.da.server.component.parser.factory.configuration.FileInput;
import org.eclipse.scada.da.server.component.parser.factory.configuration.MainGroupField;
import org.eclipse.scada.da.server.component.parser.factory.configuration.NumericGroupField;
import org.eclipse.scada.da.server.component.parser.factory.configuration.ParserFactory;
import org.eclipse.scada.da.server.component.parser.factory.configuration.ParserPackage;
import org.eclipse.scada.da.server.component.parser.factory.configuration.PlainText;
import org.eclipse.scada.da.server.component.parser.factory.configuration.SinglePattern;
import org.eclipse.scada.da.server.component.parser.factory.configuration.SplitTable;
import org.eclipse.scada.da.server.component.parser.factory.configuration.StringGroupField;
import org.eclipse.scada.da.server.component.parser.factory.configuration.UrlInput;
import org.eclipse.scada.da.server.component.parser.factory.configuration.ValueDescriptor;
import org.eclipse.scada.da.server.component.parser.factory.configuration.VariantType;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.AttributeValueImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.ComponentImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.FileInputImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.MainGroupFieldImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.NumericGroupFieldImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.PlainTextImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.SinglePatternImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.SplitTableImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.StringGroupFieldImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.UrlInputImpl;
import org.eclipse.scada.da.server.component.parser.factory.configuration.impl.ValueDescriptorImpl;

public class ParserFactoryImpl
extends EFactoryImpl
implements ParserFactory {
    public static ParserFactory init() {
        try {
            ParserFactory theParserFactory = (ParserFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/SCADA/DA/Server/Parser");
            if (theParserFactory != null) {
                return theParserFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ParserFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createComponent();
            }
            case 2: {
                return this.createFileInput();
            }
            case 4: {
                return this.createPlainText();
            }
            case 6: {
                return this.createUrlInput();
            }
            case 7: {
                return this.createSinglePattern();
            }
            case 8: {
                return this.createValueDescriptor();
            }
            case 10: {
                return this.createAttributeValue();
            }
            case 11: {
                return this.createMainGroupField();
            }
            case 12: {
                return this.createStringGroupField();
            }
            case 13: {
                return this.createNumericGroupField();
            }
            case 14: {
                return this.createSplitTable();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 15: {
                return this.createVariantTypeFromString(eDataType, initialValue);
            }
            case 19: {
                return this.createPatternFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 15: {
                return this.convertVariantTypeToString(eDataType, instanceValue);
            }
            case 19: {
                return this.convertPatternToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Component createComponent() {
        ComponentImpl component = new ComponentImpl();
        return component;
    }

    @Override
    public FileInput createFileInput() {
        FileInputImpl fileInput = new FileInputImpl();
        return fileInput;
    }

    @Override
    public PlainText createPlainText() {
        PlainTextImpl plainText = new PlainTextImpl();
        return plainText;
    }

    @Override
    public UrlInput createUrlInput() {
        UrlInputImpl urlInput = new UrlInputImpl();
        return urlInput;
    }

    @Override
    public SinglePattern createSinglePattern() {
        SinglePatternImpl singlePattern = new SinglePatternImpl();
        return singlePattern;
    }

    @Override
    public ValueDescriptor createValueDescriptor() {
        ValueDescriptorImpl valueDescriptor = new ValueDescriptorImpl();
        return valueDescriptor;
    }

    @Override
    public AttributeValue createAttributeValue() {
        AttributeValueImpl attributeValue = new AttributeValueImpl();
        return attributeValue;
    }

    @Override
    public MainGroupField createMainGroupField() {
        MainGroupFieldImpl mainGroupField = new MainGroupFieldImpl();
        return mainGroupField;
    }

    @Override
    public StringGroupField createStringGroupField() {
        StringGroupFieldImpl stringGroupField = new StringGroupFieldImpl();
        return stringGroupField;
    }

    @Override
    public NumericGroupField createNumericGroupField() {
        NumericGroupFieldImpl numericGroupField = new NumericGroupFieldImpl();
        return numericGroupField;
    }

    @Override
    public SplitTable createSplitTable() {
        SplitTableImpl splitTable = new SplitTableImpl();
        return splitTable;
    }

    public VariantType createVariantTypeFromString(EDataType eDataType, String initialValue) {
        VariantType result = VariantType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertVariantTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Pattern createPatternFromString(EDataType eDataType, String initialValue) {
        return Pattern.compile(initialValue);
    }

    public String convertPatternToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ParserPackage getParserPackage() {
        return (ParserPackage)this.getEPackage();
    }

    @Deprecated
    public static ParserPackage getPackage() {
        return ParserPackage.eINSTANCE;
    }
}

