/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.common;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.common.HiveSourceListener;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ServiceListenerHiveSource
implements HiveSource {
    private final SingleServiceTracker<Hive> tracker;
    private final Set<HiveSourceListener> listeners = new HashSet<HiveSourceListener>();
    private final SingleServiceListener<Hive> listener = new SingleServiceListener<Hive>(){

        public void serviceChange(ServiceReference<Hive> reference, Hive service) {
            ServiceListenerHiveSource.this.handleServiceChange(service);
        }
    };
    private Hive service;
    private final Executor executor;

    public ServiceListenerHiveSource(BundleContext context, Executor executor) {
        this.executor = executor;
        this.tracker = new SingleServiceTracker(context, Hive.class, this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServiceChange(final Hive service) {
        ServiceListenerHiveSource serviceListenerHiveSource = this;
        synchronized (serviceListenerHiveSource) {
            this.service = service;
            for (final HiveSourceListener listener : this.listeners) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.setHive(service);
                    }
                });
            }
        }
    }

    public void open() {
        this.tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.tracker.close();
        ServiceListenerHiveSource serviceListenerHiveSource = this;
        synchronized (serviceListenerHiveSource) {
            this.service = null;
            for (final HiveSourceListener listener : this.listeners) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.setHive(null);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final HiveSourceListener listener) {
        ServiceListenerHiveSource serviceListenerHiveSource = this;
        synchronized (serviceListenerHiveSource) {
            boolean added = this.listeners.add(listener);
            final Hive hive = this.service;
            if (added && hive != null) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.setHive(hive);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(HiveSourceListener listener) {
        ServiceListenerHiveSource serviceListenerHiveSource = this;
        synchronized (serviceListenerHiveSource) {
            this.listeners.remove(listener);
        }
    }
}

