/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.DataItemOutput;
import org.eclipse.scada.da.server.common.WriteAttributesHelper;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemCommand
extends DataItemOutput {
    private static final Logger logger = LoggerFactory.getLogger(DataItemCommand.class);
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Executor executor;

    public DataItemCommand(String id, Executor executor) {
        super(id);
        this.executor = executor;
    }

    @Override
    public NotifyFuture<WriteResult> startWriteValue(final Variant value, OperationParameters operationParameters) {
        FutureTask task = new FutureTask((Callable)new Callable<WriteResult>(){

            @Override
            public WriteResult call() throws Exception {
                DataItemCommand.this.processWrite(value);
                return null;
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    public void processWrite(Variant value) throws InvalidOperationException {
        for (Listener listener : this.listeners) {
            try {
                listener.command(value);
            }
            catch (Throwable e) {
                logger.warn("Failed to run listener", e);
                throw new InvalidOperationException();
            }
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Map<String, Variant> getAttributes() {
        return new HashMap<String, Variant>();
    }

    @Override
    public NotifyFuture<WriteAttributeResults> startSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantFuture((Object)WriteAttributesHelper.errorUnhandled(null, attributes));
    }

    public static interface Listener {
        public void command(Variant var1) throws Exception;
    }
}

