/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.server.common.AuthorizationProvider;
import org.eclipse.scada.core.server.common.AuthorizedOperation;
import org.eclipse.scada.core.server.common.ServiceCommon;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.core.subscription.ListenableSubscriptionManager;
import org.eclipse.scada.core.subscription.SubscriptionListener;
import org.eclipse.scada.core.subscription.SubscriptionManagerListener;
import org.eclipse.scada.core.subscription.SubscriptionSource;
import org.eclipse.scada.core.subscription.SubscriptionValidator;
import org.eclipse.scada.core.subscription.ValidationException;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.core.server.InvalidItemException;
import org.eclipse.scada.da.core.server.Session;
import org.eclipse.scada.da.core.server.browser.HiveBrowser;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.ValidationStrategy;
import org.eclipse.scada.da.server.common.factory.DataItemFactory;
import org.eclipse.scada.da.server.common.factory.DataItemValidator;
import org.eclipse.scada.da.server.common.impl.DataItemSubscriptionSource;
import org.eclipse.scada.da.server.common.impl.HiveBrowserCommon;
import org.eclipse.scada.da.server.common.impl.SessionCommon;
import org.eclipse.scada.da.server.common.impl.SessionListener;
import org.eclipse.scada.da.server.common.impl.stats.HiveCommonStatisticsGenerator;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.PermissionDeniedException;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.eclipse.scada.utils.concurrent.CallingFuture;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveCommon
extends ServiceCommon<Session, SessionCommon>
implements Hive {
    private static final Logger logger = LoggerFactory.getLogger(HiveCommon.class);
    private final Set<SessionCommon> sessions = new HashSet<SessionCommon>();
    private final Map<String, DataItem> itemMap = new HashMap<String, DataItem>(1000);
    private Lock itemMapReadLock;
    private Lock itemMapWriteLock;
    private HiveBrowserCommon browser;
    private Folder rootFolder;
    private final Set<SessionListener> sessionListeners = new CopyOnWriteArraySet<SessionListener>();
    private volatile ExecutorService operationService;
    private final List<DataItemFactory> factoryList = new CopyOnWriteArrayList<DataItemFactory>();
    private ListenableSubscriptionManager<String> itemSubscriptionManager;
    private final Set<DataItemValidator> itemValidators = new CopyOnWriteArraySet<DataItemValidator>();
    private ValidationStrategy validationStrategy = ValidationStrategy.GRANT_ALL;
    private HiveCommonStatisticsGenerator statisticsGenerator;
    private boolean autoEnableStats = true;
    private final ReadWriteLock browserLock = new ReentrantReadWriteLock();
    private final AuthorizationProvider<AbstractSessionImpl> authorizationProvider = new AuthorizationProvider<AbstractSessionImpl>(){

        public NotifyFuture<UserInformation> impersonate(AbstractSessionImpl session, String targetUserName, CallbackHandler handler) {
            return HiveCommon.this.makeEffectiveUserInformation(session, targetUserName, handler);
        }

        public NotifyFuture<AuthorizationReply> authorize(AuthorizationRequest authorizationRequest, CallbackHandler callbackHandler, AuthorizationResult defaultResult) {
            return HiveCommon.this.authorize(authorizationRequest, callbackHandler, defaultResult);
        }
    };
    private final AtomicBoolean running = new AtomicBoolean();
    private SubscriptionValidator<String> subscriptionValidator;
    private static final String DATA_ITEM_OBJECT_TYPE = "ITEM";

    public HiveCommon() {
        ReentrantReadWriteLock itemMapLock = new ReentrantReadWriteLock(Boolean.getBoolean("org.eclipse.scada.da.server.common.fairItemMapLock"));
        this.itemMapReadLock = itemMapLock.readLock();
        this.itemMapWriteLock = itemMapLock.writeLock();
        this.subscriptionValidator = new SubscriptionValidator<String>(){

            public boolean validate(SubscriptionListener<String> listener, String topic) {
                return HiveCommon.this.validateItem(topic);
            }
        };
    }

    protected void addItemSubscriptionListener(SubscriptionManagerListener<String> listener) {
        this.checkRunning();
        this.itemSubscriptionManager.addManagerListener(listener);
    }

    protected void removeItemSubscriptionListener(SubscriptionManagerListener<String> listener) {
        this.checkRunning();
        this.itemSubscriptionManager.removeManagerListener(listener);
    }

    public void start() throws Exception {
        logger.info("Starting Hive");
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.operationService = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("HiveCommon/" + this.getHiveId()));
        this.itemSubscriptionManager = new ListenableSubscriptionManager((Executor)this.operationService, this.subscriptionValidator);
        if (this.autoEnableStats && this.rootFolder instanceof FolderCommon) {
            this.enableStats((FolderCommon)this.rootFolder);
        }
        this.performStart();
    }

    public void stop() throws Exception {
        logger.info("Stopping hive");
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        this.performStop();
        this.disableStats();
        try {
            this.itemMapWriteLock.lock();
            this.itemMap.clear();
        }
        finally {
            this.itemMapWriteLock.unlock();
        }
        this.browserLock.writeLock().lock();
        try {
            if (this.browser != null) {
                this.browser.stop();
                this.browser = null;
            }
        }
        finally {
            this.browserLock.writeLock().unlock();
        }
        if (this.itemSubscriptionManager != null) {
            this.itemSubscriptionManager.dispose();
            this.itemSubscriptionManager = null;
        }
        if (this.operationService != null) {
            this.operationService.shutdown();
            this.operationService = null;
        }
    }

    protected void performStart() throws Exception {
    }

    protected void performStop() throws Exception {
    }

    public abstract String getHiveId();

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    private void fireSessionCreate(AbstractSessionImpl session) {
        if (this.statisticsGenerator != null) {
            this.statisticsGenerator.sessionCreated(session);
        }
        for (SessionListener listener : this.sessionListeners) {
            try {
                listener.create(session);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionDestroy(SessionCommon session) {
        if (this.statisticsGenerator != null) {
            this.statisticsGenerator.sessionDestroyed(session);
        }
        Set<SessionListener> set = this.sessionListeners;
        synchronized (set) {
            for (SessionListener listener : this.sessionListeners) {
                try {
                    listener.destroy(session);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected synchronized void setRootFolder(Folder rootFolder) {
        if (this.rootFolder == null) {
            this.rootFolder = rootFolder;
        }
    }

    private void enableStats(FolderCommon rootFolder) {
        HiveCommonStatisticsGenerator stats;
        this.disableStats();
        this.statisticsGenerator = stats = new HiveCommonStatisticsGenerator("statistics");
        FolderCommon statsFolder = new FolderCommon();
        rootFolder.add("statistics", statsFolder, (Map<String, Variant>)new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"A folder containing statistic items")).getMap());
        stats.register(this, statsFolder);
    }

    private void disableStats() {
        if (this.statisticsGenerator == null) {
            return;
        }
        this.statisticsGenerator.unregister();
        this.statisticsGenerator = null;
        if (this.rootFolder instanceof FolderCommon && this.autoEnableStats) {
            ((FolderCommon)this.rootFolder).remove("statistics");
        }
    }

    public SessionCommon validateSession(org.eclipse.scada.core.server.Session session) throws InvalidSessionException {
        if (!(session instanceof SessionCommon)) {
            throw new InvalidSessionException();
        }
        SessionCommon sessionCommon = (SessionCommon)session;
        if (sessionCommon.getHive() != this) {
            throw new InvalidSessionException();
        }
        if (!this.sessions.contains(sessionCommon)) {
            throw new InvalidSessionException();
        }
        return sessionCommon;
    }

    public NotifyFuture<Session> createSession(final Properties properties, final CallbackHandler callbackHandler) {
        if (!this.running.get()) {
            return new InstantErrorFuture((Throwable)HiveCommon.makeCheckRunningException());
        }
        NotifyFuture loginFuture = this.loginUser(properties, callbackHandler);
        return new CallingFuture<UserInformation, Session>(loginFuture){

            public Session call(Future<UserInformation> future) throws Exception {
                return HiveCommon.this.createSession(future, properties, callbackHandler);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createSession(Future<UserInformation> loginFuture, Properties properties, CallbackHandler callbackHandler) throws InterruptedException, ExecutionException {
        UserInformation user = loginFuture.get();
        logger.debug("Create Session - user: {}", (Object)user);
        HashMap<String, String> sessionProperties = new HashMap<String, String>();
        this.fillSessionProperties(user, sessionProperties);
        SessionCommon session = new SessionCommon(this, user, sessionProperties);
        this.handleSessionCreated(session, properties, user);
        Set<SessionCommon> set = this.sessions;
        synchronized (set) {
            this.sessions.add(session);
            this.fireSessionCreate(session);
        }
        return session;
    }

    protected void handleSessionCreated(AbstractSessionImpl session, Properties properties, UserInformation userInformation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(Session session) throws InvalidSessionException {
        SessionCommon sessionCommon = this.validateSession((org.eclipse.scada.core.server.Session)session);
        this.checkRunning();
        Set<SessionCommon> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
        logger.info("Close session: {}", (Object)session);
        this.fireSessionDestroy((SessionCommon)session);
        this.itemSubscriptionManager.unsubscribeAll((SubscriptionListener)sessionCommon);
        sessionCommon.dispose();
    }

    public void subscribeItem(Session session, String itemId) throws InvalidSessionException, InvalidItemException {
        logger.debug("Subscribing item: {}", (Object)itemId);
        this.checkRunning();
        SessionCommon sessionCommon = this.validateSession((org.eclipse.scada.core.server.Session)session);
        try {
            this.retrieveItem(itemId);
            this.itemSubscriptionManager.subscribe((Object)itemId, (SubscriptionListener)sessionCommon);
        }
        catch (ValidationException validationException) {
            throw new InvalidItemException(itemId);
        }
    }

    public void unsubscribeItem(Session session, String itemId) throws InvalidSessionException, InvalidItemException {
        logger.debug("Unsubscribing item: {}", (Object)itemId);
        this.checkRunning();
        SessionCommon sessionCommon = this.validateSession((org.eclipse.scada.core.server.Session)session);
        this.itemSubscriptionManager.unsubscribe((Object)itemId, (SubscriptionListener)sessionCommon);
    }

    private void checkRunning() {
        if (!this.running.get()) {
            throw HiveCommon.makeCheckRunningException();
        }
    }

    private static IllegalStateException makeCheckRunningException() {
        return new IllegalStateException("Hive is not running running. Start it first!");
    }

    public void registerItem(DataItem item) {
        logger.debug("Register item: {}", (Object)item);
        this.checkRunning();
        try {
            this.itemMapWriteLock.lock();
            String id = item.getInformation().getName();
            if (!this.itemMap.containsKey(id)) {
                this.itemMap.put(id, item);
                if (this.statisticsGenerator != null) {
                    this.statisticsGenerator.itemRegistered(item);
                }
            } else {
                logger.warn(String.format("Duplicate error: item %s already registered with hive", item.getInformation().getName()));
            }
            this.itemSubscriptionManager.setSource((Object)id, (SubscriptionSource)new DataItemSubscriptionSource(this.getOperationService(), item, this.statisticsGenerator));
        }
        finally {
            this.itemMapWriteLock.unlock();
        }
    }

    private Executor getOperationServiceInstance() {
        this.checkRunning();
        return this.operationService;
    }

    public Executor getOperationService() {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                Executor executor = HiveCommon.this.getOperationServiceInstance();
                if (executor == null) {
                    throw new IllegalStateException("Hive is disposed");
                }
                executor.execute(command);
            }
        };
    }

    public void unregisterItem(DataItem item) {
        logger.debug("Unregister item: {}", (Object)item);
        if (!this.running.get()) {
            return;
        }
        try {
            this.itemMapWriteLock.lock();
            String id = item.getInformation().getName();
            if (this.itemMap.containsKey(id)) {
                this.itemMap.remove(id);
                if (this.statisticsGenerator != null) {
                    this.statisticsGenerator.itemUnregistered(item);
                }
            }
            this.itemSubscriptionManager.setSource((Object)id, null);
        }
        finally {
            this.itemMapWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void factoryCreate(String id) {
        logger.debug("FactoryCreate - itemId: {}", (Object)id);
        List<DataItemFactory> list = this.factoryList;
        synchronized (list) {
            for (DataItemFactory factory : this.factoryList) {
                if (!factory.canCreate(id)) continue;
                factory.create(id);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean validateItem(String id) {
        if (this.validationStrategy == ValidationStrategy.GRANT_ALL) {
            return true;
        }
        if (this.lookupItem(id) != null) {
            return true;
        }
        for (DataItemValidator dataItemValidator : this.itemValidators) {
            if (!dataItemValidator.isValid(id)) continue;
            return true;
        }
        List<DataItemFactory> list = this.factoryList;
        synchronized (list) {
            DataItemFactory factory;
            Iterator<DataItemFactory> iterator = this.factoryList.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(factory = iterator.next()).canCreate(id));
            return true;
        }
    }

    public DataItem lookupItem(String id) {
        try {
            this.itemMapReadLock.lock();
            DataItem dataItem = this.itemMap.get(id);
            return dataItem;
        }
        finally {
            this.itemMapReadLock.unlock();
        }
    }

    protected DataItem retrieveItem(String id) {
        DataItem dataItem = this.lookupItem(id);
        if (dataItem != null) {
            return dataItem;
        }
        this.factoryCreate(id);
        return this.lookupItem(id);
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(Session session, final String itemId, final Map<String, Variant> attributes, OperationParameters operationParameters, CallbackHandler callbackHandler) throws InvalidSessionException, InvalidItemException, PermissionDeniedException {
        final SessionCommon sessionCommon = this.validateSession((org.eclipse.scada.core.server.Session)session);
        return new AuthorizedOperation<WriteAttributeResults, AbstractSessionImpl>(this.authorizationProvider, (AbstractSessionImpl)sessionCommon, DATA_ITEM_OBJECT_TYPE, itemId, "WRITE_ATTRIBUTES", this.makeSetAttributesContext(attributes), operationParameters, sessionCommon.wrapCallbackHandler(callbackHandler), DEFAULT_RESULT){

            protected NotifyFuture<WriteAttributeResults> granted(org.eclipse.scada.core.server.OperationParameters effectiveOperationParameters) {
                return HiveCommon.this.processWriteAttributes(sessionCommon, itemId, attributes, effectiveOperationParameters);
            }
        };
    }

    protected NotifyFuture<WriteAttributeResults> processWriteAttributes(SessionCommon session, String itemId, Map<String, Variant> attributes, org.eclipse.scada.core.server.OperationParameters operationParameters) {
        logger.debug("Process write attributes - itemId: {}, attributes: {}", (Object)itemId, attributes);
        DataItem item = this.retrieveItem(itemId);
        if (item == null) {
            return new InstantErrorFuture(new InvalidItemException(itemId).fillInStackTrace());
        }
        if (this.statisticsGenerator != null) {
            this.statisticsGenerator.startWriteAttributes(session, itemId, attributes.size());
        }
        NotifyFuture<WriteAttributeResults> future = item.startSetAttributes(attributes, operationParameters);
        try {
            session.addFuture(future);
            return future;
        }
        catch (InvalidSessionException e) {
            return new InstantErrorFuture((Throwable)e);
        }
    }

    private Map<String, Object> makeSetAttributesContext(Map<String, Variant> attributes) {
        HashMap<String, Object> context = new HashMap<String, Object>(1);
        context.put("attributes", attributes);
        return context;
    }

    private Map<String, Object> makeWriteValueContext(Variant value) {
        HashMap<String, Object> context = new HashMap<String, Object>(1);
        context.put("value", value);
        return context;
    }

    public NotifyFuture<WriteResult> startWrite(Session session, final String itemId, final Variant value, OperationParameters operationParameters, CallbackHandler callbackHandler) throws InvalidSessionException, InvalidItemException {
        final SessionCommon sessionCommon = this.validateSession((org.eclipse.scada.core.server.Session)session);
        return new AuthorizedOperation<WriteResult, AbstractSessionImpl>(this.authorizationProvider, (AbstractSessionImpl)sessionCommon, DATA_ITEM_OBJECT_TYPE, itemId, "WRITE", this.makeWriteValueContext(value), operationParameters, sessionCommon.wrapCallbackHandler(callbackHandler), DEFAULT_RESULT){

            protected NotifyFuture<WriteResult> granted(org.eclipse.scada.core.server.OperationParameters effectiveOperationParameters) {
                return HiveCommon.this.processWrite(sessionCommon, itemId, value, effectiveOperationParameters);
            }
        };
    }

    protected NotifyFuture<WriteResult> processWrite(SessionCommon session, String itemId, Variant value, org.eclipse.scada.core.server.OperationParameters effectiveOperationParameters) {
        logger.debug("Processing write - granted - itemId: {}, value: {}", (Object)itemId, (Object)value);
        DataItem item = this.retrieveItem(itemId);
        if (item == null) {
            return new InstantErrorFuture(new InvalidItemException(itemId).fillInStackTrace());
        }
        if (this.statisticsGenerator != null) {
            this.statisticsGenerator.startWrite(session, itemId, value);
        }
        NotifyFuture<WriteResult> future = item.startWriteValue(value, effectiveOperationParameters);
        try {
            session.addFuture(future);
            return future;
        }
        catch (InvalidSessionException e) {
            return new InstantErrorFuture((Throwable)e);
        }
    }

    public HiveBrowser getBrowser() {
        this.browserLock.readLock().lock();
        try {
            if (this.browser != null || this.rootFolder == null) {
                HiveBrowserCommon hiveBrowserCommon = this.browser;
                return hiveBrowserCommon;
            }
        }
        finally {
            this.browserLock.readLock().unlock();
        }
        this.browserLock.writeLock().lock();
        try {
            if (this.browser != null || this.rootFolder == null) {
                HiveBrowserCommon hiveBrowserCommon = this.browser;
                return hiveBrowserCommon;
            }
            this.browser = new HiveBrowserCommon(this){

                @Override
                public Folder getRootFolder() {
                    return HiveCommon.this.rootFolder;
                }
            };
            this.browser.start();
            HiveBrowserCommon hiveBrowserCommon = this.browser;
            return hiveBrowserCommon;
        }
        finally {
            this.browserLock.writeLock().unlock();
        }
    }

    public void addItemFactory(DataItemFactory factory) {
        this.factoryList.add(factory);
    }

    public void removeItemFactory(DataItemFactory factory) {
        this.factoryList.remove(factory);
    }

    public Set<String> getGrantedItems() {
        return this.itemSubscriptionManager.getAllGrantedTopics();
    }

    public void addDataItemValidator(DataItemValidator dataItemValidator) {
        this.itemValidators.add(dataItemValidator);
    }

    public void removeItemValidator(DataItemValidator dataItemValidator) {
        this.itemValidators.remove(dataItemValidator);
    }

    protected ValidationStrategy getValidationStrategy() {
        return this.validationStrategy;
    }

    protected void setValidatonStrategy(ValidationStrategy validatonStrategy) {
        this.validationStrategy = validatonStrategy;
    }

    public boolean isAutoEnableStats() {
        return this.autoEnableStats;
    }

    public void setAutoEnableStats(boolean autoEnableStats) {
        this.autoEnableStats = autoEnableStats;
    }
}

