/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.movingaverage;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.movingaverage.MovingAverageDataSourceFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private ScheduledExecutorService scheduler;
    private ExecutorService executor;
    private MovingAverageDataSourceFactory factory;
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(String.valueOf(context.getBundle().getSymbolicName()) + ".executor"));
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(String.valueOf(context.getBundle().getSymbolicName()) + ".scheduler"));
        this.factory = new MovingAverageDataSourceFactory(context, this.executor, this.scheduler);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "An averaging data source over time");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", context.getBundle().getSymbolicName());
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.factory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.factory.dispose();
        this.executor.shutdown();
        this.scheduler.shutdown();
        Activator.context = null;
    }
}

