/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.net;

import java.io.IOException;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.multiton.SingleSessionIoHandler;
import org.apache.mina.handler.multiton.SingleSessionIoHandlerDelegate;
import org.apache.mina.handler.multiton.SingleSessionIoHandlerFactory;
import org.eclipse.scada.ae.server.Service;
import org.eclipse.scada.ae.server.exporter.ExporterBase;
import org.eclipse.scada.ae.server.net.ServerConnectionHandler;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.server.net.Server;

public class Exporter
extends ExporterBase {
    private Server server;

    public Exporter(Service service, ConnectionInformation connectionInformation) throws Exception {
        super(service, connectionInformation);
    }

    private void createServer() throws IOException {
        this.server = new Server(this.connectionInformation);
        this.server.start(this.createFactory());
    }

    private SingleSessionIoHandlerDelegate createFactory() {
        return new SingleSessionIoHandlerDelegate(new SingleSessionIoHandlerFactory(){

            public SingleSessionIoHandler getHandler(IoSession session) throws Exception {
                return new ServerConnectionHandler(Exporter.this.service, session, Exporter.this.connectionInformation);
            }
        });
    }

    public void start() throws Exception {
        this.createServer();
    }

    public void stop() throws Exception {
        this.destroyServer();
    }

    private void destroyServer() {
        if (this.server != null) {
            this.server.dispose();
            this.server = null;
        }
    }
}

