/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.master.internal.MasterFactory;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private MasterFactory masterFactory;
    private ServiceRegistration<ConfigurationFactory> masterHandle;
    private ObjectPoolTracker<DataSource> dataSourceTracker;

    public void start(BundleContext context) throws Exception {
        this.dataSourceTracker = new ObjectPoolTracker(context, DataSource.class);
        this.dataSourceTracker.open();
        this.masterFactory = new MasterFactory(context, this.dataSourceTracker);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("factoryId", "master.item");
        ((Dictionary)properties).put("service.description", "A configuration factory for master items");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        this.masterHandle = context.registerService(ConfigurationFactory.class, (Object)this.masterFactory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.dataSourceTracker.close();
        this.masterHandle.unregister();
        this.masterFactory.dispose();
        this.masterFactory = null;
    }
}

