/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.testing;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;

public class TimeDataItem
extends DataItemInputChained {
    private ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> job;
    private String format;

    public TimeDataItem(String id, ScheduledExecutorService executor) {
        super(id, (Executor)executor);
        this.scheduledExecutor = executor;
    }

    public synchronized void update(Map<String, String> parameters) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.setPeriod(cfg.getIntegerChecked("period", "'period' must be set to a positive integer value"));
        this.format = cfg.getString("format", null);
    }

    private synchronized void setPeriod(int period) {
        if (this.job != null) {
            this.job.cancel(false);
            this.job = null;
        }
        this.job = this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TimeDataItem.this.tick();
            }
        }, 0L, period, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Variant value;
        TimeDataItem timeDataItem = this;
        synchronized (timeDataItem) {
            value = this.format == null ? Variant.valueOf((long)System.currentTimeMillis()) : Variant.valueOf((Object)String.format(this.format, new Date()));
        }
        this.updateData(value, null, null);
    }

    public synchronized void dispose() {
        this.scheduledExecutor = null;
        this.job.cancel(false);
        this.job = null;
    }
}

