/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.extractor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.CommonItemFactory;
import org.eclipse.scada.da.server.common.item.factory.DefaultChainItemFactory;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.command.ExecutionResult;
import org.eclipse.scada.da.server.exec.extractor.Extractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseExtractor.class);
    private final List<DataItemInputChained> inputs = new LinkedList<DataItemInputChained>();
    private FolderItemFactory itemFactory;
    private Hive hive;
    private final String id;

    public AbstractBaseExtractor(String id) {
        this.id = id;
    }

    protected DataItemInputChained createInput(String localId) {
        DataItemInputChained item = this.itemFactory.createInput(localId, null);
        this.inputs.add(item);
        return item;
    }

    @Override
    public void process(ExecutionResult result) {
        if (result.getExecutionError() != null) {
            this.setError(result.getExecutionError(), "exec");
        } else {
            try {
                this.doProcess(result);
            }
            catch (Throwable e) {
                this.setError(e, "value");
            }
        }
    }

    protected void setError(Throwable executionError, String which) {
        logger.info("Setting error", executionError);
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put(String.valueOf(which) + ".error", Variant.valueOf((boolean)true));
        if (executionError != null) {
            attributes.put(String.valueOf(which) + ".error.message", Variant.valueOf((Object)executionError.getMessage()));
        }
        for (DataItemInputChained item : this.inputs) {
            item.updateData(null, attributes, AttributeMode.UPDATE);
        }
    }

    protected void fillNoError(Map<String, Variant> attributes) {
        attributes.put("exec.error", null);
        attributes.put("exec.error.message", null);
        attributes.put("value.error", null);
        attributes.put("value.error.message", null);
    }

    protected abstract void doProcess(ExecutionResult var1) throws Exception;

    @Override
    public void register(Hive hive, FolderItemFactory folderItemFactory) {
        this.hive = hive;
        this.itemFactory = new DefaultChainItemFactory((CommonItemFactory)folderItemFactory, (HiveCommon)this.hive, folderItemFactory.getFolder(), this.id, this.id);
        folderItemFactory.addSubFactory((ItemFactory)this.itemFactory);
    }

    @Override
    public void unregister() {
        this.inputs.clear();
        this.itemFactory.dispose();
    }
}

