/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamProcessor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StreamProcessor.class);
    private final InputStream stream;
    private final int bufferSize;
    private final CharBuffer charBuffer;

    public StreamProcessor(InputStream stream, int bufferSize) {
        this.stream = stream;
        this.bufferSize = bufferSize;
        this.charBuffer = CharBuffer.allocate(this.bufferSize);
    }

    @Override
    public void run() {
        try {
            try {
                this.read();
                this.streamClosed();
            }
            catch (Throwable e) {
                this.readerFailed(e);
                this.close();
            }
        }
        finally {
            this.close();
        }
    }

    private void streamClosed() {
        logger.error("Stream closed");
    }

    private void readerFailed(Throwable e) {
        logger.error("Failed failed", e);
    }

    private void read() throws IOException {
        int i;
        int offset = 0;
        byte[] buffer = new byte[this.bufferSize];
        while ((i = this.stream.read(buffer, offset, buffer.length - offset)) > 0) {
            logger.debug(String.format("Read %s bytes", i));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, i);
            this.handleNewInput(new InputStreamReader(inputStream));
            logger.debug(String.format("%s byte(s) remaining", inputStream.available()));
            offset = inputStream.available();
            if (buffer.length - offset > 0) continue;
            throw new RuntimeException("Buffer is full");
        }
    }

    private void handleNewInput(InputStreamReader inputStreamReader) {
        try {
            this.charBuffer.clear();
            while (inputStreamReader.read(this.charBuffer) > 0) {
                this.charBuffer.flip();
                if (logger.isDebugEnabled()) {
                    logger.debug("Reader: " + this.charBuffer.toString());
                }
                this.handleInput(this.charBuffer.toString());
                this.charBuffer.clear();
            }
        }
        catch (IOException iOException) {}
    }

    protected abstract void handleInput(String var1);

    private void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {}
    }
}

