/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.stock.items;

import java.util.HashMap;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItemInputCommon;
import org.eclipse.scada.da.server.common.ItemListener;
import org.eclipse.scada.da.server.stock.domain.StockQuote;
import org.eclipse.scada.da.server.stock.items.StockQuoteListener;
import org.eclipse.scada.da.server.stock.items.UpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockQuoteItem
extends DataItemInputCommon
implements StockQuoteListener {
    private static final Logger logger = LoggerFactory.getLogger(StockQuoteItem.class);
    private String symbol = null;
    private UpdateManager updateManager = null;

    public StockQuoteItem(String symbol, UpdateManager updateManager) {
        super(symbol);
        this.symbol = symbol;
        this.updateManager = updateManager;
    }

    public synchronized void setListener(ItemListener listener) {
        super.setListener(listener);
        if (listener != null) {
            this.wakeup();
        } else {
            this.suspend();
        }
    }

    public void suspend() {
        logger.warn(String.format("Item %1$s suspended", this.getInformation().getName()));
        this.updateManager.remove(this.symbol);
    }

    public void wakeup() {
        logger.warn(String.format("Item %1$s woken up", this.getInformation().getName()));
        this.updateManager.add(this.symbol, this);
    }

    @Override
    public void update(StockQuote stockQuote) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        Variant value = Variant.NULL;
        if (stockQuote.getValue() != null) {
            value = Variant.valueOf((Object)stockQuote.getValue());
            attributes.put("stock.error", null);
        } else {
            attributes.put("stock.error", Variant.valueOf((Object)stockQuote.getError()));
        }
        attributes.put("timestamp", Variant.valueOf((long)stockQuote.getTimestamp().getTimeInMillis()));
        this.updateData(value, attributes, AttributeMode.UPDATE);
    }
}

