/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.test.items;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.DataItemOutput;
import org.eclipse.scada.da.server.common.WriteAttributesHelper;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class WriteDelayItem
extends DataItemOutput {
    private final Executor executor;

    public WriteDelayItem(String name, Executor executor) {
        super(name);
        this.executor = executor;
    }

    public Map<String, Variant> getAttributes() {
        return new HashMap<String, Variant>();
    }

    public NotifyFuture<WriteAttributeResults> startSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantFuture((Object)WriteAttributesHelper.errorUnhandled(null, attributes));
    }

    public NotifyFuture<WriteResult> startWriteValue(final Variant value, OperationParameters operationParameters) {
        FutureTask task = new FutureTask((Callable)new Callable<WriteResult>(){

            @Override
            public WriteResult call() throws Exception {
                WriteDelayItem.this.processWrite(value);
                return new WriteResult();
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    public void processWrite(Variant value) throws InvalidOperationException, NullValueException, NotConvertableException, OperationException {
        int delay = value.asInteger();
        System.out.println("Start write: " + delay + "ms");
        try {
            try {
                Thread.sleep(delay);
                System.out.println("End write");
            }
            catch (InterruptedException e) {
                System.err.println("Write failed");
                e.printStackTrace();
                throw new OperationException("Interrupted");
            }
        }
        finally {
            System.out.println("leave write");
        }
    }
}

