/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.base.data;

import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;

public class Message {
    public static final int CC_UNKNOWN_COMMAND_CODE = 1;
    public static final int CC_FAILED = 2;
    public static final int CC_ACK = 3;
    public static final int CC_PING = 16;
    public static final int CC_PONG = 17;
    public static final String FIELD_ERROR_INFO = "error-info";
    private int commandCode = 0;
    private long sequence = 0L;
    private long replySequence = 0L;
    private long timestamp = System.currentTimeMillis();
    private MapValue values = null;

    public Message() {
        this.values = new MapValue();
    }

    public Message(int commandCode) {
        this.commandCode = commandCode;
        this.values = new MapValue();
    }

    public Message(int commandCode, long replySequence) {
        this.commandCode = commandCode;
        this.replySequence = replySequence;
        this.values = new MapValue();
    }

    public int getCommandCode() {
        return this.commandCode;
    }

    public void setCommandCode(int commandCode) {
        this.commandCode = commandCode;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public MapValue getValues() {
        return this.values;
    }

    public void setValues(MapValue values) {
        this.values = values;
    }

    public long getReplySequence() {
        return this.replySequence;
    }

    public void setReplySequence(long replySequence) {
        this.replySequence = replySequence;
    }

    public void setValue(String name, Value value) {
        this.values.put(name, value);
    }

    public void setValue(String name, String value) {
        this.values.put(name, new StringValue(value));
    }

    public void unsetValue(String name) {
        this.values.remove(name);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return String.format("[Message - cc: %s, seq: %s]", this.commandCode, this.sequence);
    }
}

