/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.http.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;

public class EventSerializer {
    public static final String isoDatePattern = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final Gson gson = new GsonBuilder().setDateFormat(0).setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").registerTypeAdapter(Variant.class, (Object)new VariantTypeAdapter()).create();

    public static String serializeEvent(Event event) {
        return gson.toJson((Object)event);
    }

    public static Event deserializeEvent(String event) {
        return (Event)gson.fromJson(event, Event.class);
    }

    private static class VariantTypeAdapter
    implements JsonSerializer<Variant>,
    JsonDeserializer<Variant> {
        private VariantTypeAdapter() {
        }

        public JsonElement serialize(Variant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public Variant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            VariantEditor ve = new VariantEditor();
            ve.setAsText(json.getAsJsonPrimitive().getAsString());
            return (Variant)ve.getValue();
        }
    }
}

