/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.client.ConnectionFactory;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.server.proxy.Hive;
import org.eclipse.scada.da.server.proxy.configuration.ConnectionType;
import org.eclipse.scada.da.server.proxy.configuration.ProxyType;
import org.eclipse.scada.da.server.proxy.configuration.RootType;
import org.eclipse.scada.da.server.proxy.connection.ProxyConnection;
import org.eclipse.scada.da.server.proxy.utils.ProxyPrefixName;

public class XMLConfigurator {
    private final RootType root;
    private final Map<String, Connection> connections = new HashMap<String, Connection>();

    public XMLConfigurator(RootType root) {
        this.root = root;
    }

    public void configure(Hive hive) throws ClassNotFoundException, InvalidOperationException, NullValueException, NotConvertableException {
        if (this.root.isSetSeparator()) {
            hive.setSeparator(this.root.getSeparator());
        }
        for (ProxyType proxyConf : this.root.getProxy()) {
            ProxyConnection proxyConnection = hive.addConnection(new ProxyPrefixName(proxyConf.getPrefix()));
            proxyConnection.setWait(proxyConf.getWait());
            for (ConnectionType connectionConf : proxyConf.getConnection()) {
                Connection connection = this.createConnection(connectionConf.getUri(), connectionConf.getClassName());
                proxyConnection.addConnection(connection, connectionConf.getId(), new ProxyPrefixName(connectionConf.getPrefix()));
            }
        }
    }

    private Connection createConnection(String uri, String className) throws ClassNotFoundException {
        Connection connection = this.connections.get(uri);
        if (connection == null) {
            if (className != null && className.length() > 0) {
                Class.forName(className);
            }
            connection = (Connection)ConnectionFactory.create((ConnectionInformation)ConnectionInformation.fromURI((String)uri));
            this.connections.put(uri, connection);
        }
        return connection;
    }
}

