/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.client.ItemManager;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.query.GroupFolder;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.IDNameProvider;
import org.eclipse.scada.da.server.browser.common.query.InvisibleStorage;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.ItemStorage;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.PatternNameProvider;
import org.eclipse.scada.da.server.browser.common.query.SplitGroupProvider;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.proxy.Hive;
import org.eclipse.scada.da.server.proxy.connection.ProxyFolder;
import org.eclipse.scada.da.server.proxy.connection.ProxySubConnection;
import org.eclipse.scada.da.server.proxy.item.ProxyDataItem;
import org.eclipse.scada.da.server.proxy.item.ProxyItemUpdateListener;
import org.eclipse.scada.da.server.proxy.item.ProxyValueHolder;
import org.eclipse.scada.da.server.proxy.item.ProxyWriteHandlerImpl;
import org.eclipse.scada.da.server.proxy.utils.ProxyPrefixName;
import org.eclipse.scada.da.server.proxy.utils.ProxySubConnectionId;
import org.eclipse.scada.da.server.proxy.utils.ProxyUtils;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.eclipse.scada.utils.lifecycle.LifecycleAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyGroup
implements LifecycleAware {
    private static final String FOLDER_NAME_REGISTERED_ITEMS = "registeredItems";
    private static final Logger logger = LoggerFactory.getLogger(ThreadFactoryImplementation.class);
    private static Executor defaultExecutor = new Executor(){

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    };
    private final Set<ConnectionStateListener> connectionStateListeners = new CopyOnWriteArraySet<ConnectionStateListener>();
    private ProxySubConnectionId currentConnection;
    private ProxyPrefixName prefix;
    private final Map<String, ProxyDataItem> registeredItems = new ConcurrentHashMap<String, ProxyDataItem>();
    private FolderCommon connectionFolder;
    private final Hive hive;
    private final Lock switchLock = new ReentrantLock();
    private Executor itemListenerExecutor = defaultExecutor;
    private final Map<ProxySubConnectionId, ProxySubConnection> subConnections = new HashMap<ProxySubConnectionId, ProxySubConnection>();
    private int wait;
    private ProxyFolder proxyFolder;
    private final Object realizeMutex = new Object();
    private InvisibleStorage registeredItemsStorage;
    private GroupFolder registeredItemsFolder;

    public ProxyGroup(Hive hive, ProxyPrefixName prefix) {
        this.hive = hive;
        this.prefix = prefix;
        if (Boolean.getBoolean("org.eclipse.scada.da.server.proxy.asyncListener")) {
            ThreadFactoryImplementation tf = new ThreadFactoryImplementation(prefix.getName());
            this.itemListenerExecutor = Executors.newSingleThreadExecutor(tf);
        }
    }

    public void start() {
        this.createProxyFolder();
        this.registeredItemsStorage = new InvisibleStorage();
        this.registeredItemsFolder = new GroupFolder((GroupProvider)new SplitGroupProvider((NameProvider)new IDNameProvider(), Pattern.quote(this.hive.getSeparator())), (NameProvider)new PatternNameProvider((NameProvider)new IDNameProvider(), Pattern.compile("^.*" + Pattern.quote(this.hive.getSeparator()) + "(.*?)$"), 1));
        this.connectionFolder.add(FOLDER_NAME_REGISTERED_ITEMS, (Folder)this.registeredItemsFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"The folder which contains all realized items")).getMap());
        this.registeredItemsStorage.addChild((ItemStorage)this.registeredItemsFolder);
    }

    public void stop() {
        this.connectionFolder.remove(FOLDER_NAME_REGISTERED_ITEMS);
        this.registeredItemsStorage.removeChild((ItemStorage)this.registeredItemsFolder);
        this.registeredItemsStorage = null;
        this.registeredItemsFolder = null;
        this.destroyProxyFolder();
    }

    public FolderCommon getConnectionFolder() {
        return this.connectionFolder;
    }

    public void setConnectionFolder(FolderCommon connectionFolder) {
        this.connectionFolder = connectionFolder;
    }

    private Connection currentConnection() {
        return this.currentSubConnection().getConnection();
    }

    private ProxySubConnection currentSubConnection() {
        return this.subConnections.get(this.currentConnection);
    }

    public void addConnection(Connection connection, String id, ProxyPrefixName prefix, FolderCommon connectionFolder) throws InvalidOperationException, NullValueException, NotConvertableException {
        ProxySubConnectionId proxySubConnectionId = new ProxySubConnectionId(id);
        if (this.subConnections.containsKey(proxySubConnectionId)) {
            throw new IllegalArgumentException("connection with id " + proxySubConnectionId + " already exists!");
        }
        logger.info("Adding new connection: {} -> {}", (Object)id, (Object)connection.getConnectionInformation());
        ProxySubConnection proxySubConnection = new ProxySubConnection(connection, this.prefix, proxySubConnectionId, prefix, this.hive, connectionFolder);
        this.subConnections.put(proxySubConnectionId, proxySubConnection);
        if (this.currentConnection == null) {
            this.currentConnection = proxySubConnectionId;
        }
    }

    public void addConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListeners.add(connectionStateListener);
        this.currentConnection().addConnectionStateListener(connectionStateListener);
    }

    public ProxySubConnectionId getCurrentConnection() {
        return this.currentConnection;
    }

    public ProxyPrefixName getPrefix() {
        return this.prefix;
    }

    public Map<String, ProxyDataItem> getRegisteredItems() {
        return this.registeredItems;
    }

    public String getSeparator() {
        return this.hive.getSeparator();
    }

    public Map<ProxySubConnectionId, ProxySubConnection> getSubConnections() {
        return this.subConnections;
    }

    public int getWait() {
        return this.wait;
    }

    public String convertToOriginalId(String itemId) {
        return ProxyUtils.originalItemId(itemId, this.hive.getSeparator(), this.getPrefix(), this.currentSubConnection().getPrefix());
    }

    public String convertToProxyId(String itemId) {
        if (ProxyUtils.isOriginalItemForProxyGroup(itemId, this.hive.getSeparator(), this.currentSubConnection().getPrefix())) {
            return ProxyUtils.proxyItemId(itemId, this.hive.getSeparator(), this.getPrefix(), this.currentSubConnection().getPrefix());
        }
        return null;
    }

    public void disconnectCurrentConnection() {
        this.currentSubConnection().disconnect();
    }

    public void connectCurrentConnection() {
        this.currentSubConnection().connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyDataItem realizeItem(String id) {
        Object object = this.realizeMutex;
        synchronized (object) {
            ProxyDataItem item = this.registeredItems.get(id);
            if (item == null) {
                ProxyValueHolder pvh = new ProxyValueHolder(this.hive.getSeparator(), this.getPrefix(), this.getCurrentConnection(), id);
                ProxyWriteHandlerImpl pwh = new ProxyWriteHandlerImpl(this.hive.getSeparator(), this.getPrefix(), this.getSubConnections(), this.getCurrentConnection(), id);
                item = new ProxyDataItem(id, pvh, pwh, this.hive.getOperationService());
                this.registeredItems.put(id, item);
                this.setUpItem(item, id);
            }
            return item;
        }
    }

    private void setUpItem(ProxyDataItem item, String requestId) {
        this.registeredItemsStorage.added(new ItemDescriptor((DataItem)item, new MapBuilder().getMap()));
        for (ProxySubConnection subConnection : this.getSubConnections().values()) {
            ItemManager itemManager = subConnection.getItemManager();
            String originalItemId = ProxyUtils.originalItemId(requestId, this.hive.getSeparator(), this.getPrefix(), subConnection.getPrefix());
            itemManager.addItemUpdateListener(originalItemId, (ItemUpdateListener)new ProxyItemUpdateListener(this.itemListenerExecutor, item, subConnection));
        }
    }

    public void removeConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListeners.remove(connectionStateListener);
        this.currentConnection().removeConnectionStateListener(connectionStateListener);
    }

    public void setPrefix(ProxyPrefixName prefix) {
        this.prefix = prefix;
    }

    public void setWait(int wait) {
        this.wait = wait;
    }

    public void switchTo(ProxySubConnectionId newConnectionId) {
        logger.warn("Switching from '{}' to '{}'", (Object)this.currentConnection, (Object)newConnectionId);
        boolean locked = false;
        try {
            locked = this.switchLock.tryLock(Integer.getInteger("org.eclipse.scada.da.server.proxy.switchLockTimeout", 2000).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn(String.format("Failed switching from '%s' to '%s'. Got interrupted while waiting!", this.currentConnection, newConnectionId), (Throwable)e);
            return;
        }
        if (!locked) {
            logger.warn("Failed switching from '{]' to '{}'. Switching is still in progress!", (Object)this.currentConnection, (Object)newConnectionId);
            return;
        }
        try {
            for (ConnectionStateListener listener : this.connectionStateListeners) {
                this.currentConnection().removeConnectionStateListener(listener);
            }
            for (ProxyDataItem proxyDataItem : this.registeredItems.values()) {
                proxyDataItem.getProxyValueHolder().switchTo(newConnectionId);
            }
            this.currentConnection = newConnectionId;
            for (ConnectionStateListener listener : this.connectionStateListeners) {
                this.currentConnection().addConnectionStateListener(listener);
            }
            this.createProxyFolder();
        }
        finally {
            logger.info("Release switch lock");
            this.switchLock.unlock();
        }
    }

    private void destroyProxyFolder() {
        if (this.proxyFolder != null) {
            this.connectionFolder.remove((Folder)this.proxyFolder);
            this.proxyFolder = null;
        }
    }

    private void createProxyFolder() {
        this.destroyProxyFolder();
        this.proxyFolder = new ProxyFolder(this.currentSubConnection().getFolderManager(), this, new Location());
        this.connectionFolder.add("items", (Folder)this.proxyFolder, null);
    }

    private static final class ThreadFactoryImplementation
    implements ThreadFactory {
        private final String name;

        public ThreadFactoryImplementation(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "ProxyItemListener/" + this.name);
            t.setDaemon(true);
            return t;
        }
    }
}

