/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.provider.ca;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.authn.AbstractPlainAuthenticationService;

public class AuthenticationServiceImpl
extends AbstractPlainAuthenticationService
implements ConfigurationFactory {
    private final Map<String, AbstractPlainAuthenticationService.UserEntry> entries = new HashMap<String, AbstractPlainAuthenticationService.UserEntry>();
    private final Lock readLock;
    private final Lock writeLock;

    public AuthenticationServiceImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    protected AbstractPlainAuthenticationService.UserEntry getUserEntry(String name) throws Exception {
        this.readLock.lock();
        try {
            AbstractPlainAuthenticationService.UserEntry userEntry = this.entries.get(name);
            return userEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void update(UserInformation userInformation, String configurationId, Map<String, String> properties) throws Exception {
        AbstractPlainAuthenticationService.UserEntry entry = new AbstractPlainAuthenticationService.UserEntry(properties.get("password"), this.makeRoles(properties));
        this.writeLock.lock();
        try {
            this.entries.put(configurationId, entry);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Collection<String> makeRoles(Map<String, String> properties) {
        HashSet<String> result = new HashSet<String>();
        String roles = properties.get("roles");
        if (roles != null) {
            String[] toks = roles.split("[, \\t\\n\\r]+");
            result.addAll(Arrays.asList(toks));
        }
        return result;
    }

    public void delete(UserInformation userInformation, String configurationId) throws Exception {
        this.writeLock.lock();
        try {
            this.entries.remove(configurationId);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

