/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.script;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.sec.callback.ConfirmationCallback;
import org.eclipse.scada.sec.provider.script.Messages;
import org.eclipse.scada.sec.provider.script.Result;
import org.eclipse.scada.utils.concurrent.CallingFuture;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.utils.statuscodes.SeverityLevel;
import org.eclipse.scada.utils.statuscodes.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationEntry
implements AuthorizationRule {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationEntry.class);
    private final ScriptExecutor script;
    private final ScriptExecutor callbackScript;
    private final AuthenticationImplementation authenticationImplementation;

    public AuthorizationEntry(ScriptExecutor script, ScriptExecutor callbackScript, AuthenticationImplementation authenticationImplementation) {
        this.script = script;
        this.callbackScript = callbackScript;
        this.authenticationImplementation = authenticationImplementation;
    }

    public void dispose() {
    }

    protected Map<String, Object> makeBindings(AuthorizationContext context) {
        AuthorizationRequest request = context.getRequest();
        String objectType = request.getObjectType();
        String objectId = request.getObjectId();
        String action = request.getAction();
        UserInformation userInformation = request.getUserInformation();
        Map contextData = request.getContext();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("authorizationContext", context);
        bindings.put("request", request);
        bindings.put("id", objectId);
        bindings.put("type", objectType);
        bindings.put("action", action);
        bindings.put("user", userInformation);
        bindings.put("GRANTED", AuthorizationResult.GRANTED);
        bindings.put("ABSTAIN", AuthorizationResult.ABSTAIN);
        bindings.put("requestContext", contextData);
        bindings.put("authenticator", this.authenticationImplementation);
        bindings.put("Callbacks", new CallbackBuilder(context.getCallbackHandler()));
        return bindings;
    }

    public NotifyFuture<AuthorizationResult> authorize(final AuthorizationContext context) {
        Object result;
        final Map<String, Object> bindings = this.makeBindings(context);
        final SimpleScriptContext ctx = new SimpleScriptContext();
        try {
            result = this.script.execute((ScriptContext)ctx, bindings);
            logger.debug("Result is: {}", result);
        }
        catch (Exception e) {
            logger.debug("Failed to execute", (Throwable)e);
            return new InstantErrorFuture((Throwable)e);
        }
        if (result instanceof NotifyFuture) {
            NotifyFuture future = (NotifyFuture)result;
            return new CallingFuture<Object, AuthorizationResult>(future){

                public AuthorizationResult call(Future<Object> future) throws Exception {
                    return AuthorizationEntry.this.handleCallback(context, bindings, ctx, future);
                }
            };
        }
        return new InstantFuture((Object)this.generateResult(context, result));
    }

    protected AuthorizationResult handleCallback(AuthorizationContext context, Map<String, Object> bindings, SimpleScriptContext ctx, Future<Object> future) throws Exception {
        logger.debug("Called back: {}", future);
        bindings.put("future", future);
        Object result = this.callbackScript.execute((ScriptContext)ctx, bindings);
        return this.generateResult(context, result);
    }

    private AuthorizationResult generateResult(AuthorizationContext context, Object eval) {
        logger.debug("Authentication result: {}", eval);
        if (eval == null) {
            return AuthorizationResult.ABSTAIN;
        }
        if (eval instanceof Boolean) {
            if (((Boolean)eval).booleanValue()) {
                return AuthorizationResult.GRANTED;
            }
            return AuthorizationResult.createReject((StatusCode)new StatusCode("OSSEC", "SCRIPT", 1L, SeverityLevel.ERROR), (String)Messages.getString("AuthorizationEntry.error.1.message"));
        }
        if (eval instanceof Number) {
            if (((Number)eval).longValue() == 0L) {
                return AuthorizationResult.GRANTED;
            }
            return AuthorizationResult.createReject((StatusCode)new StatusCode("OSSEC", "SCRIPT", 2L, SeverityLevel.ERROR), (String)String.format(Messages.getString("AuthorizationEntry.error.2.message"), eval));
        }
        if (eval instanceof String) {
            if (((String)eval).isEmpty()) {
                return AuthorizationResult.GRANTED;
            }
            return AuthorizationResult.createReject((StatusCode)new StatusCode("OSSEC", "SCRIPT", 3L, SeverityLevel.ERROR), (String)String.format(eval.toString(), eval));
        }
        if (eval instanceof StatusCode) {
            return AuthorizationResult.createReject((StatusCode)((StatusCode)eval), (String)Messages.getString("AuthorizationEntry.error.defaultMessage"));
        }
        if (eval instanceof Throwable) {
            return AuthorizationResult.createReject((Throwable)((Throwable)eval));
        }
        if (eval instanceof AuthorizationResult) {
            return (AuthorizationResult)eval;
        }
        if (eval instanceof UserInformation) {
            context.changeUserInformation((UserInformation)eval);
            return AuthorizationResult.ABSTAIN;
        }
        if (eval instanceof Result) {
            Result result = (Result)eval;
            return AuthorizationResult.createReject((StatusCode)result.getCode(), (String)result.getMessage());
        }
        return AuthorizationResult.createReject((StatusCode)new StatusCode("OSSEC", "SCRIPT", 4L, SeverityLevel.ERROR), (String)String.format(Messages.getString("AuthorizationEntry.unknownResultType"), eval));
    }

    public static class CallbackBuilder {
        private final CallbackHandler callbackHandler;

        public CallbackBuilder(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }

        public NotifyFuture<Callback[]> confirm(String message, String type) {
            ConfirmationCallback.ConfirmationType confirmationType = type == null || type.isEmpty() ? ConfirmationCallback.ConfirmationType.CONFIRM : ConfirmationCallback.ConfirmationType.valueOf((String)type);
            return Callbacks.callback((CallbackHandler)this.callbackHandler, (Callback)new ConfirmationCallback(confirmationType, message, 0));
        }
    }
}

