/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.jdbc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.ValidationStrategy;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.jdbc.Connection;
import org.eclipse.scada.da.server.jdbc.ConnectionFactory;
import org.eclipse.scada.da.server.jdbc.DefaultConnectionFactory;
import org.eclipse.scada.da.server.jdbc.Query;
import org.eclipse.scada.da.server.jdbc.TabularQuery;
import org.eclipse.scada.da.server.jdbc.Update;
import org.eclipse.scada.da.server.jdbc.configuration.AbstractQueryType;
import org.eclipse.scada.da.server.jdbc.configuration.ColumnMappingType;
import org.eclipse.scada.da.server.jdbc.configuration.CommandsType;
import org.eclipse.scada.da.server.jdbc.configuration.ConfigurationPackage;
import org.eclipse.scada.da.server.jdbc.configuration.ConnectionType;
import org.eclipse.scada.da.server.jdbc.configuration.DocumentRoot;
import org.eclipse.scada.da.server.jdbc.configuration.PropertyEntry;
import org.eclipse.scada.da.server.jdbc.configuration.QueryType;
import org.eclipse.scada.da.server.jdbc.configuration.RootType;
import org.eclipse.scada.da.server.jdbc.configuration.TabularQueryType;
import org.eclipse.scada.da.server.jdbc.configuration.UpdateColumnsType;
import org.eclipse.scada.da.server.jdbc.configuration.UpdateMappingType;
import org.eclipse.scada.da.server.jdbc.configuration.UpdateType;
import org.eclipse.scada.da.server.jdbc.configuration.util.ConfigurationResourceFactoryImpl;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive
extends HiveCommon {
    private static final Logger logger = LoggerFactory.getLogger(Hive.class);
    private final FolderCommon rootFolder;
    private final Collection<Connection> connections = new LinkedList<Connection>();
    private ScheduledExecutorService timer;
    private final ConnectionFactory connectionFactory;
    private final RootType root;

    public Hive() throws IOException {
        this(Hive.parse(URI.createFileURI((String)"configuration.xml")), null);
    }

    public Hive(String uri, BundleContext bundleContext) throws IOException {
        this(Hive.parse(URI.createURI((String)uri)), bundleContext);
    }

    public Hive(RootType root, BundleContext bundleContext) {
        this.root = root;
        this.connectionFactory = new DefaultConnectionFactory(bundleContext);
        this.rootFolder = new FolderCommon();
        this.setRootFolder((Folder)this.rootFolder);
        this.setValidatonStrategy(ValidationStrategy.GRANT_ALL);
    }

    private static RootType parse(URI uri) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ConfigurationResourceFactoryImpl());
        Resource r = rs.createResource(uri);
        r.load(null);
        DocumentRoot doc = (DocumentRoot)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)ConfigurationPackage.Literals.DOCUMENT_ROOT);
        if (doc == null) {
            return null;
        }
        return doc.getRoot();
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.jdbc";
    }

    protected void performStart() throws Exception {
        super.performStart();
        this.timer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("JdbcHiveTimer", true));
        this.configure();
        this.register();
    }

    protected void performStop() throws Exception {
        this.timer.shutdown();
        this.unregister();
        super.performStop();
    }

    public void register() {
        for (Connection connection : this.connections) {
            connection.register(this, this.rootFolder, this.timer);
        }
    }

    public void unregister() {
        for (Connection connection : this.connections) {
            connection.unregister(this);
        }
    }

    private void configure() {
        for (ConnectionType connectionType : this.root.getConnection()) {
            this.createConnection(connectionType);
        }
    }

    private void createConnection(ConnectionType connectionType) {
        Properties properties = this.convert((List<PropertyEntry>)connectionType.getProperty());
        if (connectionType.getUsername() != null) {
            properties.put("user", connectionType.getUsername());
        }
        if (connectionType.getPassword() != null) {
            properties.put("password", connectionType.getPassword());
        }
        Connection connection = new Connection(this.connectionFactory, connectionType.getId(), connectionType.getTimeout(), connectionType.getConnectionClass(), connectionType.getUri(), properties);
        for (AbstractQueryType queryType : connectionType.getQuery()) {
            this.createQuery(connection, (QueryType)queryType, this.convertMappings((List<ColumnMappingType>)queryType.getColumnMapping()));
        }
        for (AbstractQueryType queryType : connectionType.getTabularQuery()) {
            this.createTabularQuery(connection, (TabularQueryType)queryType, this.convertMappings((List<ColumnMappingType>)queryType.getColumnMapping()), this.convertUpdateColumns((TabularQueryType)queryType), this.convertCommands((TabularQueryType)queryType));
        }
        for (UpdateType updateType : connectionType.getUpdate()) {
            this.createUpdate(connection, updateType);
        }
        this.connections.add(connection);
    }

    private Properties convert(List<PropertyEntry> properties) {
        Properties result = new Properties();
        if (properties != null) {
            for (PropertyEntry pe : properties) {
                result.put(pe.getKey(), pe.getValue());
            }
        }
        return result;
    }

    private Map<String, String> convertCommands(TabularQueryType queryType) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (CommandsType command : queryType.getCommands()) {
            String sql = command.getSql();
            if (sql == null || sql.isEmpty()) {
                sql = command.getSql1();
            }
            result.put(command.getLocalName(), sql);
        }
        return result;
    }

    private Map<String, String> convertUpdateColumns(TabularQueryType queryType) {
        String defaultUpdateSql = queryType.getDefaultUpdateSql();
        if (defaultUpdateSql == null || defaultUpdateSql.isEmpty()) {
            defaultUpdateSql = queryType.getDefaultUpdateSql1();
        }
        if (defaultUpdateSql == null || defaultUpdateSql.isEmpty()) {
            return Collections.emptyMap();
        }
        if (queryType.getUpdateColumns() == null || queryType.getUpdateColumns().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(queryType.getUpdateColumns().size());
        for (UpdateColumnsType updateCol : queryType.getUpdateColumns()) {
            String updateSql = updateCol.getCustomUpdateSql();
            if (updateSql == null || updateSql.isEmpty()) {
                result.put(updateCol.getColumnName(), String.format(defaultUpdateSql, updateCol.getColumnName()));
                continue;
            }
            result.put(updateCol.getColumnName(), updateSql);
        }
        return result;
    }

    private Map<Integer, String> convertMappings(List<ColumnMappingType> list) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (ColumnMappingType mapping : list) {
            result.put(mapping.getColumnNumber(), mapping.getAliasName());
        }
        return result;
    }

    private void createUpdate(Connection connection, UpdateType updateType) {
        String sql = updateType.getSql();
        if (sql == null || sql.length() == 0) {
            sql = updateType.getSql1();
        }
        logger.info("Create update: {}", (Object)sql);
        Update update = new Update(updateType.getId(), sql, connection);
        for (UpdateMappingType mappingValue : updateType.getMapping()) {
            update.addMapping(new Update.Mapping(mappingValue.getName(), mappingValue.getNamedParameter()));
        }
        connection.add(update);
    }

    private void createQuery(Connection connection, QueryType queryType, Map<Integer, String> columnAliases) {
        String sql = queryType.getSql();
        if (sql == null || sql.length() == 0) {
            sql = queryType.getSql1();
        }
        logger.info("Creating new query: {}", (Object)sql);
        connection.add(new Query(queryType.getId(), queryType.getPeriod(), sql, connection, this.convertTimeout(queryType.getTimeout()), columnAliases));
    }

    private void createTabularQuery(Connection connection, TabularQueryType queryType, Map<Integer, String> columnAliases, Map<String, String> updateMap, Map<String, String> commands) {
        String sql = queryType.getSql();
        if (sql == null || sql.isEmpty()) {
            sql = queryType.getSql1();
        }
        logger.info("Creating new tabular query: {} / {}", (Object)sql);
        connection.add(new TabularQuery(queryType.getId(), queryType.getIdColumn(), queryType.getPeriod(), sql, connection, this.convertTimeout(queryType.getTimeout()), columnAliases, updateMap, commands));
    }

    private Integer convertTimeout(BigInteger timeout) {
        if (timeout == null) {
            return null;
        }
        return timeout.intValue();
    }
}

