/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.script;

import com.google.common.collect.Interner;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.monitor.script.ScriptMonitorFactory;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.interner.InternerHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private Interner<String> stringInterner;
    private ScriptMonitorFactory factory;
    private ExecutorService executor;
    private EventProcessor eventProcessor;
    private ObjectPoolTracker<DataSource> dataSourcePoolTracker;
    private ObjectPoolTracker<MasterItem> masterItemPoolTracker;
    private ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> configAdminTracker;
    private ObjectPoolImpl<MonitorService> monitorServicePool;
    private ServiceRegistration<?> monitorServicePoolHandler;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.stringInterner = InternerHelper.makeInterner((String)"org.eclipse.scada.ae.monitor.datasource.common.stringInternerType", (String)"strong");
        this.executor = new ExportedExecutorService(bundleContext.getBundle().getSymbolicName(), 1, 1, 1L, TimeUnit.MINUTES);
        this.eventProcessor = new EventProcessor(context);
        this.eventProcessor.open();
        this.dataSourcePoolTracker = new ObjectPoolTracker(context, DataSource.class);
        this.dataSourcePoolTracker.open();
        this.masterItemPoolTracker = new ObjectPoolTracker(context, MasterItem.class);
        this.masterItemPoolTracker.open();
        this.configAdminTracker = new ServiceTracker(context, ConfigurationAdministrator.class, null);
        this.configAdminTracker.open();
        this.monitorServicePool = new ObjectPoolImpl();
        this.monitorServicePoolHandler = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.monitorServicePool, MonitorService.class);
        this.factory = new ScriptMonitorFactory(bundleContext, this.executor, this.stringInterner, this.eventProcessor, this.dataSourcePoolTracker, this.masterItemPoolTracker, this.configAdminTracker, this.monitorServicePool);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("factoryId", "org.eclipse.scada.ae.monitor.script");
        properties.put("service.description", "Script monitor");
        context.registerService(new String[]{ConfigurationFactory.class.getName()}, (Object)this.factory, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.factory.dispose();
        this.monitorServicePoolHandler.unregister();
        this.monitorServicePool.dispose();
        this.dataSourcePoolTracker.close();
        this.masterItemPoolTracker.close();
        this.configAdminTracker.close();
        this.eventProcessor.close();
        this.executor.shutdown();
        context = null;
    }
}

